# pylint: disable=missing-docstring
# coding:utf-8
import os
import sys

from basesdk import utils

LOG = utils.log_module("/var/log/huawei/dj/install.log")


def save_ini(c_file):
    ret = 0 if os.path.exists(c_file) else 1
    utils.check_result(ret, "Config file not exist", LOG)
    cmd = ['cp', '-f', c_file, '/opt/huawei/dj/cfg/sys.ini']
    ret, _ = utils.run_cmd(cmd)
    utils.check_result(ret, "Save config file failed", LOG)
    LOG.info("Save config file(%s) Successfully." % utils.get_info("profile"))


def ntp_time_sync(root):
    script = "%s/bin/osConfig/ntp_time_sync.sh" % root
    ret, _ = utils.run_cmd(['sh', script])
    utils.check_result(ret, "Ntp time sync failed", LOG)
    LOG.info("Ntp time sync Successfully.")


def check_software_exist():
    path = "/opt/huawei/dj/cfg/dj.version"
    ret = 0 if not os.path.exists(path) else 1
    utils.check_result(ret, "Karbor software has already installed", LOG)
    LOG.info("Karbor software has not installed, check OK.")


def install_uninstall(root):
    dir_name = "/opt/huawei/dj/inst"
    cmd = ['cp', '-f',
           "%s/bin/uninstall.sh" % root,
           dir_name]
    ret, _ = utils.run_cmd(cmd)
    utils.check_result(ret, "Init uninstall script failed", LOG)
    cmd = ['cp', '-f',
           "%s/bin/utils.sh" % root,
           "%s/bin/parseyaml.py" % root,
           "%s/bin/srvmanager.py" % root,
           "%s/bin/" % dir_name]
    ret, _ = utils.run_cmd(cmd)
    utils.check_result(ret, "Init uninstall tool script failed", LOG)
    LOG.info("Uninstall script init ok.")


def check_ini(root):
    script = "%s/bin/preCheck/check_sys_ini.sh" % root
    ret, _ = utils.run_cmd(['sh', script])
    utils.check_result(ret, "Check sys ini failed", LOG)
    LOG.info("Check sys ini ok.")


def check_others(root):
    script = "%s/bin/preCheck/preCheck.sh" % root
    ret, _ = utils.run_cmd(['sh', script])
    utils.check_result(ret, "Check system info failed", LOG)
    LOG.info("Check system info ok.")


def check_service_config(root):
    script = "%s/bin/srvmanager.py" % root
    ret, _ = utils.run_cmd(['csbs_python', script, root, 'check'])
    utils.check_result(ret, "Check service config failed", LOG)
    LOG.info("Check service config ok.")


def os_config(root):
    script = "%s/bin/osConfig/OSConfig.sh" % root
    ret, _ = utils.run_cmd(['sh', script])
    utils.check_result(ret, "Config os failed", LOG)
    LOG.info("Config os ok.")


if __name__ == '__main__':
    config_file = sys.argv[2]
    cur_dir = os.path.split(os.path.realpath(__file__))[0]
    root_dir = cur_dir.split("/bin")[0]
    print(".........Start to install Karbor..........")
    LOG.info(".........Start to install Karbor..........")
    save_ini(config_file)
    check_software_exist()
    check_ini(root_dir)
    check_others(root_dir)
    check_service_config(root_dir)
    msg = "Successfully Check the configuration file."
    utils.print_and_judge_progress(5, True, msg)
    install_uninstall(root_dir)
    ntp_time_sync(root_dir)
    os_config(root_dir)
    msg = "Successfully Config os and time."
    utils.print_and_judge_progress(10, True, msg)
