#!/bin/bash
cur_dir=$(dirname $(readlink -f $0))
source $(dirname ${cur_dir})/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
UNINSTALL_PATH="/opt/huawei/dj/inst"

# ================================= install ====================================
function install()
{
    log_info "Start to install Karbor."
    source /etc/bashrc
    if [ ! -f ../$1 ]; then
        sh install.sh -f $1
    else
        sh install.sh -f ../$1
    fi
    CHECK_RESULT $? "Install karbor failed."
    log_info "Install Karbor successfully."
}

# ================================= check ======================================
function check()
{
    log_info "Start to check whether karbor has been installed successfully."

    # check karbor
    if [ ! -f "/opt/huawei/dj/cfg/dj.version" ];then
        log_error "Check karbor end, install karbor failed."
        exit 1
    fi

    log_info "Check karbor end, karbor has been installed successfully."
}

# ================================= rollback ===================================
function rollback()
{
    log_info "Start to rollback karbor."
    cd ${UNINSTALL_PATH}
    echo -e "y\n" | sh uninstall.sh
    CHECK_RESULT $? "Uninstall karbor failed."
    log_info "Rollback Karbor successfully."
}

# ================================= main =======================================
main()
{
    if [ $# -lt 1 ]; then
        log_error "Parameter error. Usage: bash install_karbor.sh [install|check|rollback]"
        exit 1
    fi
    cd $(dirname ${cur_dir})
    case "$1" in
        install)
            install $2
        ;;
        check)
            check
        ;;
        rollback)
            rollback
        ;;
        *)
            log_error "Parameter error. Usage: bash install_karbor.sh [install|check|rollback]"
            exit 1
        ;;
    esac
}

main "$@"
exit 0