#!/bin/bash
#set +x

function get_network_name()
{
   if [[ $# -ne 1 || -z $1 ]];then
      exit 1
   fi
   ip_addr=$1
   net_name=`ip a | grep ${ip_addr} | awk -F' ' '{print $NF}'`
   if [ -z ${net_name} ];then
      exit 1
   fi
   echo ${net_name}
}

function get_network_mask()
{
   if [ $# -ne 1 ] || [ -z $1 ];then
      exit 1
   fi
   ip_addr=$1
   net_mask=`ifconfig | grep ${ip_addr} | awk -F' ' '{print $4}'`
   if [ -z ${net_mask} ];then
      exit 1
   fi
   echo ${net_mask}
}

function get_network_gateway()
{
   if [[ $# -ne 1 || -z $1 ]];then
      exit 1
   fi
   dev_name=$1
   net_gateway_array=`route -n | grep $dev_name | awk -F' ' '{print $2}'`
   net_gateway=`echo ${net_gateway_array} | awk -F' ' '{print $1}'`
   if [ -z ${net_gateway} ];then
      exit 1
   fi
   echo ${net_gateway}
}

function confirm_network_file()
{
   if [[ $# -ne 1 || -z $1 ]];then
      exit 1
   fi
   net_name=$1
   net_file=/etc/sysconfig/network-scripts/ifcfg-${net_name}
   if [ ! -f "${net_file}" ]; then
      touch "${net_file}"
   fi
   if [ ! -f "${net_file}" ]; then
      exit 1
   fi
}

function confirm_network_config()
{
   if [[ $# -ne 3 || -z $1 || -z $2 || -z $3 ]];then
      exit 1
   fi
   net_name=$1
   net_file=/etc/sysconfig/network-scripts/ifcfg-${net_name}
   config_key=$2
   config_value=$3
   old_value=`cat ${net_file} | grep $config_key=* | awk -F'=' '{print $2}'`
   if [[ -z ${old_value} || "${old_value}" != "${config_value}" ]];then
      sed -i "/$config_key=/"d ${net_file}
      echo "$config_key=${config_value}">>${net_file}
   fi
   new_value=`cat ${net_file} | grep $config_key=* | awk -F'=' '{print $2}'`
   if [[ -z ${new_value} || "${new_value}" != "${config_value}" ]];then
      exit 1
   fi
}

function confirm_network()
{
   if [[ $# -ne 1 || -z $1 ]];then
      exit 1
   fi
   net_name=$(get_network_name $1)
   net_gateway=$(get_network_gateway ${net_name})
   net_mask=$(get_network_mask $1)
   confirm_network_file ${net_name}
   confirm_network_config ${net_name} "TYPE" "Ethernet"
   confirm_network_config ${net_name} "BOOTPROTO" "static"
   confirm_network_config ${net_name} "DEFROUTE" "yes"
   confirm_network_config ${net_name} "PEERDNS" "no"
   confirm_network_config ${net_name} "PEERROUTES" "no"
   confirm_network_config ${net_name} "NAME" ${net_name}
   confirm_network_config ${net_name} "DEVICE" ${net_name}
   confirm_network_config ${net_name} "ONBOOT" "yes"
   confirm_network_config ${net_name} "IPADDR" "$1"
   confirm_network_config ${net_name} "NETMASK" "${net_mask}"
   confirm_network_config ${net_name} "GATEWAY" "${net_gateway}"
}

function disable_ipv6()
{
   sed -i '/::/'d /etc/hosts

   if [ ! -f /etc/modprobe.d/ipv6off.conf ];then
      touch /etc/modprobe.d/ipv6off.conf
      chmod 600 /etc/modprobe.d/ipv6off.conf
   fi
   echo "alias net-pf-10 off options ipv6 disable=1">/etc/modprobe.d/ipv6off.conf

   check_result=`cat /boot/grub2/grub.cfg |grep "ipv6.disable=1" |wc -l`
   if [ ${check_result} -eq 0 ];then
      echo "ipv6.disable=1">>/boot/grub2/grub.cfg
   fi

   check_result=`cat /etc/sysctl.conf |grep "net.ipv6.conf.default.disable_ipv6=1" |wc -l`
   if [ ${check_result} -eq 0 ];then
      echo "net.ipv6.conf.default.disable_ipv6=1">>/etc/sysctl.conf
   fi

   check_result=`cat /etc/sysctl.conf |grep "net.ipv6.conf.all.disable_ipv6=1" |wc -l`
   if [ ${check_result} -eq 0 ];then
      echo "net.ipv6.conf.all.disable_ipv6=1">>/etc/sysctl.conf
   fi
}

function set_ntpd_listen()
{
   check_result=`cat /etc/ntp.conf |grep "interface ignore wildcard" |wc -l`
   if [ ${check_result} -eq 0 ];then
      echo "interface ignore wildcard">>/etc/ntp.conf
   fi
   check_result=`cat /etc/ntp.conf |grep "interface listen $1" |wc -l`
   if [ ${check_result} -eq 0 ];then
      echo "interface listen $1">>/etc/ntp.conf
   fi
   service ntpd restart>/dev/null
}

function main()
{
   set_ntpd_listen $1
}

main $@
exit $?
