"""Alarm sender fro OC."""
import sys
import time
import traceback
import cms_util
import convert
import send_alarm_task
import six
from basesdk import utils  # noqa
from obj import AlarmInput

log = utils.get_logger("alarm")


def resolve_input_args():
    count = len(sys.argv)
    if count < 10:
        raise Exception("parameter number(%d) is invalid" % count)
    else:
        return AlarmInput(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4],
                          sys.argv[5], sys.argv[6], sys.argv[7], sys.argv[8],
                          sys.argv[9])


def main():
    cms_config = cms_util.get_alarm_config_from_cms()
    alarm_input = resolve_input_args()
    converter = convert.dispatch_convert(cms_config.alarm_type,
                                         cms_config.endpoint)
    if converter is None:
        raise Exception("[param converter] alarm type %s not supported" %
                        cms_config.alarm_type)
    alarm_data = converter.convert(alarm_input).to_data()
    task = send_alarm_task.dispatch_task(cms_config.alarm_type)
    if task is None:
        raise Exception("[remote task] alarm type %s not supported" %
                        cms_config.alarm_type)
    task.execute(cms_config, alarm_data)


"""
sys.argv:
1. alarm_id: see alarm_definition.csv
2. alarm_type: 0-send alarm, 1-clear alarm
3. alarm_level: 1-fatal, 2-major, 3-minor, 4-suggestion
4. alarm_cause
5. dt_time
6. moc_name
7. resource_id
8. location_info
9. additional_info
"""
if __name__ == '__main__':
    if len(sys.argv) != 10:
        log.error("Send alarm invalid params: " + six.text_type(sys.argv))
        sys.exit(1)

    param_tuple = (sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4],
                   sys.argv[5], sys.argv[6], sys.argv[7],
                   sys.argv[8], sys.argv[9])

    for _ in range(4):
        try:
            main()
            log.info("Send alarm success, params: %s, %s, %s, %s, %s, %s, %s, "
                     "%s, %s" % param_tuple)
            sys.exit(0)
        except Exception as err:
            log.error("Send alarm fail, params: %s, %s, %s, %s, %s, %s, %s, "
                      "%s, %s" % param_tuple)
            log.error(six.text_type(err))
            log.error(traceback.format_exc())
            time.sleep(20)
    else:
        log.error("Send alarm failed after retry 10 times, params: %s, %s, "
                  "%s, %s, %s, %s, %s, %s, %s" % param_tuple)
        sys.exit(1)
