from basesdk import utils


class AlarmInput(object):
    def __init__(self, alarm_id, alarm_type, alarm_level, alarm_cause, dt_time,
                 moc_name, resource_id, location_info,
                 additional_info):
        self.alarm_id = alarm_id
        self.alarm_type = alarm_type
        self.alarm_level = alarm_level
        self.alarm_cause = alarm_cause
        self.dt_time = dt_time
        self.moc_name = moc_name
        self.resource_id = resource_id
        self.location_info = location_info
        self.additional_info = additional_info


class AlarmDef(object):
    def __init__(self, alarm_id, moc_name, mo_type, severity, is_auto_clear,
                 alarm_name_en, alarm_name_ch,
                 ext_alarm_id):
        self.alarm_id = alarm_id
        self.moc_name = moc_name
        self.mo_type = mo_type
        self.severity = severity
        self.is_auto_clear = is_auto_clear
        self.alarm_name_en = alarm_name_en
        self.alarm_name_ch = alarm_name_ch
        self.ext_alarm_id = ext_alarm_id

    def get_full_alarm_name(self):
        return "%s##%s" % (self.alarm_name_ch, self.alarm_name_en)


class OCAlarmReqParam(object):
    def __init__(self, alarm_id, alarm_name, resource_id, resource_name, moc,
                 the_sn, category, severity, occur_time,
                 location_info, additional_info, cause, clear_time=0,
                 clear_type=0, is_clear=0):
        self.alarm_id = alarm_id
        self.alarm_name = alarm_name
        self.resource_id = resource_id
        self.resource_name = resource_name
        self.moc = moc
        self.the_sn = the_sn
        self.category = category
        self.severity = severity
        self.occur_time = occur_time
        self.location_info = location_info
        self.additional_info = additional_info
        self.cause = cause
        self.comp_type = "karbor"
        self.comp_id = "karbor"
        self.comp_name = "karbor"
        self.clear_time = clear_time
        self.clear_type = clear_type
        self.is_clear = is_clear

    def to_data(self):
        data = {"alarmid": self.alarm_id,
                "alarmname": self.alarm_name,
                "alarmGroupId": "278460409",
                "resourceid": self.resource_id,
                "resourceidname": self.resource_name,
                "moc": self.moc,
                "sn": self.the_sn,
                "category": self.category,
                "severity": self.severity,
                "occurtime": self.occur_time,
                "cleartime": self.clear_time,
                "cleartype": self.clear_type,
                "isclear": self.is_clear,
                "locationinfo": self.location_info,
                "additional": self.additional_info,
                "cause": self.cause,
                "comptype": self.comp_type,
                "compid": self.comp_id,
                "compname": self.comp_name}
        return data


class OC30AlarmReqParam(object):
    def __init__(self, alarm_id, alarm_name, severity, category, moc, moi,
                 sub_csn, native_me_dn, me_name, occur_utc, match_key,
                 additional_information, cause, clear_utc=0):
        self.alarm_id = alarm_id
        self.alarm_name = alarm_name
        self.severity = severity
        self.category = category
        self.moc = moc
        self.moi = moi
        self.sub_csn = sub_csn
        self.native_me_dn = native_me_dn
        self.me_name = me_name
        self.occur_utc = occur_utc
        self.match_key = match_key
        self.clear_utc = clear_utc
        self.additional_information = additional_information
        self.cause = cause

    def to_data(self):
        region_id = utils.get_info("region_id")
        region_name = utils.get_info("region_name")
        data = {
            "alarmId": self.alarm_id,
            "alarmName": self.alarm_name,
            "alarmGroupId": "278460409",
            "severity": self.severity,
            "category": self.category,
            "moc": self.moc,
            "moi": self.moi,
            "subCsn": self.sub_csn,
            "nativeMeDn": self.native_me_dn,
            "meName": self.me_name,
            "occurUtc": self.occur_utc,
            "matchKey": self.match_key,
            "clearUtc": self.clear_utc,
            "additionalInformation": self.additional_information,
            "cause": self.cause,
            "logicalRegionId": region_id,
            "logicalRegionName": region_name,
        }
        return data


class CmsAlarmConfig(object):
    def __init__(self, alarm_type, endpoint, username, password):
        self.alarm_type = alarm_type
        self.endpoint = endpoint
        self.username = username
        self.password = password
