import os

DEFAULT_CA_CERT = "/opt/huawei/dj/DJSecurity/server-ca/ca-cert.pem"
DEFAULT_CERT_FILE = '/opt/huawei/dj/DJSecurity/server-cert/cli-client/' \
                    'cli-client-cert.pem'
DEFAULT_KEY_FILE = '/opt/huawei/dj/DJSecurity/server-cert/cli-client/' \
                   'cli-client-key.pem'

DOCKER_CERT_PATHS = [
    # karbor
    ["/opt/huawei/dj/DJSecurity/server-ca/ca-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/karbor/karbor-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/karbor/karbor-key.pem"],
    # rabbitmq
    ["/opt/huawei/dj/DJSecurity/server-ca/ca-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/rabbitmq/rabbitmq-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/rabbitmq/rabbitmq-key.pem"],
    # gaussdb
    ["/opt/huawei/dj/DJSecurity/server-cert/gaussdb/ca-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/gaussdb/gaussdb-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/gaussdb/gaussdb-key.pem"],
    # cms
    ["/opt/huawei/dj/DJSecurity/server-ca/ca-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/cms/cms-cert.pem",
     "/opt/huawei/dj/DJSecurity/server-cert/cms/cms-key.pem"]
]


class PemManager(object):
    def __init__(self):
        self.ca_cert = None
        self.cert_file = None
        self.key_file = None
        if os.path.exists(DEFAULT_CA_CERT):
            self.ca_cert = DEFAULT_CA_CERT
        if os.path.exists(DEFAULT_CERT_FILE):
            self.cert_file = DEFAULT_CERT_FILE
        if os.path.exists(DEFAULT_KEY_FILE):
            self.key_file = DEFAULT_KEY_FILE

        idx = 0
        while self.ca_cert is None or self.cert_file is None:
            if idx == len(DOCKER_CERT_PATHS):
                raise Exception("ERROR: cert files not exist.")
            path_list = DOCKER_CERT_PATHS[idx]
            if os.path.exists(path_list[0]):
                self.ca_cert = path_list[0]
            if os.path.exists(path_list[1]):
                self.cert_file = path_list[1]
            if os.path.exists(path_list[2]):
                self.key_file = path_list[2]
            idx += 1

    def get_ca_cert_path(self):
        return self.ca_cert

    def get_cert_file_path(self):
        return self.cert_file

    def get_key_file_path(self):
        return self.key_file


if __name__ == "__main__":
    pem = PemManager()
    print(pem.get_ca_cert_path())
    print(pem.get_cert_file_path())
    print(pem.get_key_file_path())
