#!/bin/bash

PROFILE=`get_info.py profile`

EVENT_LEVEL_ID=(1020797 1023297 1020798 1020794 1020793
                1020792 1020787 1020804 1020805 1020778
                1020774 1020773 1020772 1020767 1020769
                1020789 1020757 1020785)
PUBLIC_ALARM_LEVEL_ID=(1020797 1023297 1020794 1020792 1020788 1020789 1020800
                1020801 1020803 1020804 1020805 1020795 1020796 1020710
                1020785)

VBS_ALARM_ID=(1020778 1020776 1020775 1020774 1020773 1020772 1020771 1020770
              1020769 1020768 1020767 1020764 1020779)

LOG_FILE_DIR_LIST=("/var/log/huawei/dj/services/system/alarm/"
                   "/var/log/fusionsphere/component/karbor/"
                   "/var/log/karbor/"
                   "/var/log/huawei/dj/services/system/rabbitmq/")
for dir in ${LOG_FILE_DIR_LIST[@]}; do
    if [ -d $dir ]; then
        LOG_FILE="${dir}oma_alarm.log"
        break
    fi
done

if [[ ! -f "${LOG_FILE}" ]]; then
    touch "${LOG_FILE}"
    chmod 640 "${LOG_FILE}"
fi

function LOG()
{
  dir=${0}
  dir=$(basename $(dirname ${dir}))/$(basename ${dir})
  echo "$(date "+%Y-%m-%d %H:%M:%S") [$1] ${dir}: $2  ${@:3}" >> $LOG_FILE
}
shopt -s expand_aliases
alias log_error="LOG ERROR $LINENO"
alias log_info="LOG INFO $LINENO"
alias log_warn="LOG WARN $LINENO"
alias log_debug="LOG DEBUG $LINENO"


log_info "Send alarm req with params: $@"
alarm_id=$1
alarm_type=$2
alarm_level=$3
alarm_time=$4
alarm_moc=$5
alarm_component=$6
alarm_resource_id=$7
alarm_location_info=$8

if [ "$PROFILE" == "public" ]; then
    alarm_additional_info="CSBS;S-CSBS;CSBS-Karbor;$9"
else
    alarm_additional_info="CSBS-VBS;$9"
    alarm_location_info="CSBS-VBS;CSBS-VBS;$8"
fi

now=`date +%s`
service_name="CSBS"
serviceom_alarm_id="102${alarm_id: -4}"

echo "${EVENT_LEVEL_ID[@]}" | grep -wq "$serviceom_alarm_id" &&  in_event="true" || in_event="false"
echo "${VBS_ALARM_ID[@]}" | grep -wq "$serviceom_alarm_id" &&  in_vbs="true" || in_vbs="false"
echo "${PUBLIC_ALARM_LEVEL_ID[@]}" | grep -wq "$serviceom_alarm_id" &&  in_alarm="true" || in_alarm="false"
if [ $alarm_type != "1" ]; then
    if [ "$PROFILE" == "public" ]; then
        if [ $in_event == "true" -a $in_alarm == "false" ]; then
            alarm_type=2
        fi
        if [ ${in_vbs} == "true" ]; then
            alarm_additional_info="VBS;VBS;$9"
        fi
    elif [ $in_event == "true" ]; then
        alarm_type=2
        alarm_additional_info="CSBS-VBS;CSBS-VBS;$9"
        alarm_location_info=$8
    fi
fi

log_info "Send alarm with params, \
serviceom_alarm_id: ${serviceom_alarm_id}, \
alarm_type:${alarm_type}, \
alarm_level:${alarm_level}, \
now:${now}, \
service_name:${service_name}, \
alarm_location_info: ${alarm_location_info}, \
alarm_additional_info: ${alarm_additional_info}"

sh /opt/ServiceOM/omm/oma/tools/sendAlarm.sh \
"${serviceom_alarm_id}" \
"${alarm_type}" \
"${alarm_level}" \
"" \
"${now}" \
"${service_name}" \
"${alarm_location_info}" \
"${alarm_location_info}" \
"${alarm_additional_info}" \
"ServiceOM"
ret=$?
if [[ 0 -eq ${ret} ]];then
  log_info "Send alarm successfully."
else
  log_error "Send alarm failed, return code is ${ret}."
fi
