#!/bin/bash
source /opt/huawei/dj/inst/bin/utils.sh
SSH_KEY_OUT_FILE="/opt/huawei/dj/DJSecurity/ssh/gaussdb_backup_base"
SSH_OPT="-o StrictHostKeyChecking=no -i ${SSH_KEY_OUT_FILE}"

function runlog()
{
    #  " $@"中的空格是故意留的,当$@中有中划线(-)的时候, 要报invalid option,
    logger -id -p local1.error -t "gaussdbBackup" " $@"
    logger -id -p local1.error -t "gaussdbopBackup" " [pid:$$] UID:[$UID] $@"
}

function runlog_and_echo()
{
    echo "gaussdbBackup: $@"
    logger -id -p local1.error -t "gaussdbBackup" " $@"
    logger -id -p local1.error -t "gaussdbopBackup" " [pid:$$] UID:[$UID] $@"
}

function runlog_restore()
{
    #  " $@"中的空格是故意留的,当$@中有中划线(-)的时候, 要报invalid option,
    logger -id -p local1.error -t "gaussdbRestore" " $@"
    logger -id -p local1.error -t "gaussdbopRestore" " [pid:$$] UID:[$UID] $@"
}

function runlog_and_echo_restore()
{
    echo "gaussdbRestore: $@"
    logger -id -p local1.error -t "gaussdbRestore" " $@"
    logger -id -p local1.error -t "gaussdbopRestore" " [pid:$$] UID:[$UID] $@"
}


#get the node that is the primary of gaussdb
function get_primary_db_node()
{
    gaussdb_ip=`csbs_python /usr/bin/get_info.py --gaussdb_nodes`
    #singe node
    if [[ ${gaussdb_ip} = "None" ]];then
        echo ${gaussdb_ip}
        return
    fi
    manage_ip_list=`csbs_python /usr/bin/get_info.py --manage_ip list`
    manage_ip=`csbs_python /usr/bin/get_info.py --manage_ip`
    nodes=$(echo ${manage_ip_list}|tr "," "\n")
    for node in ${nodes};do
        if [[  ${manage_ip} == ${node}  ]];then
            gaussdba_process=`ps -ef | grep gaussdba | grep -v 'grep ' | wc -l 2>/dev/null`
            if [[ ${gaussdba_process} -eq 0 ]];then
                continue
            fi
            role=`/opt/huawei/dj/etc/gaussdb/sync_monitor.sh get_status | grep role | awk -F : '{print $2}' | awk '{gsub(/ /,"")}1'`
            if [[ "${role}" = "Primary" ]];then
                echo ${node}
                break
            fi
            continue
        fi
        gaussdba_process=`ssh ${SSH_OPT} djmanager@${node} ps -ef | grep gaussdba | grep -v grep | wc -l`
        if [[ ${gaussdba_process} -eq 0 ]];then
            continue
        fi
        role=`ssh ${SSH_OPT} djmanager@${node} /opt/huawei/dj/etc/gaussdb/sync_monitor.sh get_status | grep role | awk -F : '{print $2}' | awk '{gsub(/ /,"")}1'`
        if [[ "${role}" = "Primary" ]];then
            echo ${node}
            break
        fi
    done
}