#! /bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
BACKUP_FILE_NAME="$2"
HOME_DIR='/opt/huawei/dj/bin/backup/backup'
source ${HOME_DIR}/gaussdb_backup_base.sh
TRY_TIMES=20

function prerestore()
{
    db_state=`docker exec gaussdb /opt/gaussdb/app/bin/gs_ctl -D /opt/fusionplatform/data/gaussdb query | grep DB_STATE | awk -F : '{print $2}' | awk '{gsub(/ /,"")}1'`
    runlog_restore "INFO | db state is ${db_state}"
    if [[ "${db_state}" != "Normal" ]];then
        runlog_and_echo_restore "ERROR | GaussDB is not normal, can not execute restore task."
        exit 1
    fi
}

function execute_restore()
{
    if [[ -f "${BACKUP_FILE_NAME}" ]];then
        docker cp -a "${BACKUP_FILE_NAME}" gaussdb:/home/gaussdba
        docker exec gaussdb bash /home/backup_restore.sh restore >/dev/null 2>&1
        if [[ $? -ne 0 ]];then
            runlog_and_echo_restore "ERROR | restore database failed."
            exit 1
        fi
        docker stop gaussdb >/dev/null 2>&1
        docker rm -f gaussdb >/dev/null 2>&1
        if [[ $? -ne 0 ]];then
            runlog_and_echo_restore "ERROR | rm gaussdb docker failed."
            exit 1
        fi
    fi
}

function stop_gaussdb()
{
    peer_node=$(get_info.py db_peer_node)
    runlog_restore "INFO | stop gaussdb service on current node."
    sh ${HOME_DIR}/serviceControl.sh -stopgaussdb >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
         runlog_and_echo_restore "ERROR | stop gaussdb service on current node failed."
         exit 1
    fi
    sleep 2
    runlog_restore "INFO | stop gaussdb service on ${peer_node}."
    ssh ${SSH_OPT} djmanager@${peer_node} ${HOME_DIR}/serviceControl.sh -stopgaussdb >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        runlog_and_echo_restore "ERROR | stop gaussdb service on ${peer_node} failed."
        exit 1
    fi
}


function start_gaussdb()
{
    peer_node=$(get_info.py db_peer_node)

    # start gaussdb with primary
    for (( i=1; i<=${TRY_TIMES}; i++ ));do
        bash /usr/local/bin/ha/ha/module/harm/plugin/script/gaussdb.sh "active" "active" "0" 0 "ha1" >>/dev/null 2>&1
        local ret=$?
        if [[ ${ret} -ne 0 ]];then
            runlog_restore "ERROR | start gaussdb with primary failed,code:${ret}."
            sleep 5
            continue
        fi
        runlog_restore "INFO | start gaussdb with primary success."
        break
    done

    #check gaussdb container
    for (( i=1; i<=${TRY_TIMES}; i++ ));do
        CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
        if [[ "${CONTAINER_ID}" == "" ]];then
            runlog_restore "INFO | start gaussdb with primary CONTAINER_ID is not exist."
            sleep 5
            continue
        fi
        runlog_restore "INFO | start gaussdb with primary CONTAINER_ID is exist."
        break
    done

    CONTAINER_ID=`docker ps -a |grep gaussdb |awk '{print $1}'`
    if [[ "${CONTAINER_ID}" == "" ]];then
        runlog_and_echo_restore "ERROR | start gaussdb with primary failed."
        exit 1
    fi
    sleep 5
    # start gaussdb service with primary
    docker exec ${CONTAINER_ID} /bin/bash -c "source /home/gaussdba/.bashrc;cd /opt/gaussdb/app/bin;gs_ctl  stop -D /opt/fusionplatform/data/gaussdb >>/dev/null 2>&1"
    if [[ $? -eq 0 ]];then
        runlog_restore "INFO | gs_ctl  stop -D /opt/fusionplatform/data/gaussdb on primary success."
    fi

    docker exec ${CONTAINER_ID} /bin/bash -c "source /home/gaussdba/.bashrc;cd /opt/gaussdb/app/bin;gs_ctl  start -D /opt/fusionplatform/data/gaussdb -M primary >>/dev/null 2>&1";
    if [[ $? -eq 0 ]];then
        runlog_restore "INFO | gs_ctl  start -D /opt/fusionplatform/data/gaussdb -M primary success."
    else
        runlog_and_echo_restore "ERROR | gs_ctl  start -D /opt/fusionplatform/data/gaussdb -M primary failed."
        exit 1
    fi

    runlog_restore "INFO | build data on standby ${peer_node}."
    ssh ${SSH_OPT} djmanager@${peer_node} ${HOME_DIR}/serviceControl.sh -buildgaussdb >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        runlog_and_echo_restore "ERROR | build gaussdb service on ${peer_node} failed."
        exit 1
    fi

    runlog_restore "INFO | restart omm-ha."
    runlog_restore "INFO | start gaussdb service on current node"
    sh ${HOME_DIR}/serviceControl.sh -startgaussdb >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        runlog_and_echo_restore "ERROR | start gaussdb service on current node failed."
        exit 1
    fi
    role=`sh /opt/huawei/dj/bin/backup/backup/gaussdb_backup_base.sh role 2>/dev/null`
    runlog_restore "INFO | start gaussdb with ${role}."

    sleep 2
    runlog_restore "INFO | start gaussdb service on ${peer_node}."
    ssh ${SSH_OPT} djmanager@${peer_node} ${HOME_DIR}/serviceControl.sh -startgaussdb >/dev/null 2>&1;
    if [[ $? -ne 0 ]];then
        runlog_and_echo_restore "ERROR | start gaussdb service on ${peer_node} failed."
        exit 1
    fi

    sleep 6
    bash /opt/huawei/dj/etc/gaussdb/sync_monitor.sh reset_status
    if [[ $? -ne 0 ]];then
        runlog_restore "ERROR | /opt/huawei/dj/etc/gaussdb/sync_monitor.sh reset_status failed."
    else
        runlog_restore "INFO | /opt/huawei/dj/etc/gaussdb/sync_monitor.sh reset_status success."
    fi
    sleep 4
    runlog_and_echo_restore "INFO | Successfully restored database."
}


function restore_db()
{
    runlog_and_echo_restore "INFO | Begin to restore GaussDB..."
    prerestore
    stop_gaussdb
    execute_restore
    start_gaussdb
    runlog_and_echo_restore "INFO | Successfully restored GaussDB."
}

function check_backup_tar()
{
    for file in $(tar -tPf  "$1");do
        if [[ "${file}" != "$2"* ]] || [[ "${file}" == *"/../"* ]] || [[ "${file}" == *"/./"* ]];then
            runlog_and_echo_restore "ERROR | $(basename "$1") is not a backup of a certificate."
            exit 1
        fi
    done
    runlog_and_echo_restore "INFO | Check backup($(basename "$1")) Success."
}


if [[ $(basename "${BACKUP_FILE_NAME}") == "digital_certificate.tar.gz" ]];then
    check_backup_tar "${BACKUP_FILE_NAME}" "/opt/huawei/dj/DJSecurity/"
    tar -P -xzvf "${BACKUP_FILE_NAME}" >/dev/null 2>&1
elif [[ $(basename "${BACKUP_FILE_NAME}") == "rmandatabackup.tar.gz" ]];then
    check_backup_tar "${BACKUP_FILE_NAME}" "/home/gaussdba/rmandatabackup/"
    restore_db
else
    runlog_and_echo_restore "ERROR | $(basename "${BACKUP_FILE_NAME}") is not a backup data."
    exit 1
fi
rm -f "${BACKUP_FILE_NAME}"