#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

prog="`basename $0`"
HOME_DIR='/opt/huawei/dj/bin/backup/backup'
RESTORE_DIR="${HOME_DIR}/restore_file"
DB_RESTORE_DIR=""
BACKUP_FILE_NAME=""
FAILED_FLAG=0
source ${HOME_DIR}/gaussdb_backup_base.sh

function args_err()
{
    echo -e "${prog}: illegal option"
    usage="Usage: ${prog} "
    len=${#usage}
    echo "Usage: ${prog} [-f file path]"
    exit 1
}

function prerun()
{
    uncompress_and_check_file
    runlog_restore "INFO | check backup file is ok "
}

function uncompress_and_check_file()
{
    mkdir -p ${RESTORE_DIR}
    tar -zxvf ${BACKUP_FILE_NAME} -C ${RESTORE_DIR}>/dev/null 2>&1
    tgz_file_name=$(find ${RESTORE_DIR}/backup_file_package -name "*.hmac")
    check_hmac_result=`csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.verify_file_hmac(kmc.kmc.KMC_DOMAIN.DEFAULT,'${tgz_file_name}'))"`
    if [[ "${check_hmac_result}" != "True" ]];then
        while [[ 1 -eq 1 ]];do
            echo "The backup file has been changed. Are you sure you want to continue?(Y/N):"
            read char
            if [[ "${char}" = "y" || "${char}" = "Y" ]];then
                break
            elif [[ "${char}" = "n" || "${char}" = "N" ]];then
                clear_file
                exit 1
            else
                continue
            fi 
        done
                
    fi
    tar -zxvf ${RESTORE_DIR}/backup_file_package/gaussdb_backup*.tar.gz -C ${RESTORE_DIR}/backup_file_package>>/dev/null 2>&1
    DB_RESTORE_DIR=$(cd ${RESTORE_DIR}/backup_file_package/gaussdb_backup*/ && pwd)
    gaussdb_version=`cat ${DB_RESTORE_DIR}/dj_and_gaussdb_version.json | awk 'NR==1'`
    dj_version=`cat  ${DB_RESTORE_DIR}/dj_and_gaussdb_version.json | awk 'NR==2'`
    DB_VERSION=$(docker exec gaussdb /opt/gaussdb/app/bin/gs_ctl -V | awk -F " " '{print $2}')
    if [[ "${gaussdb_version}" != "${DB_VERSION}" ]];then
        while [[ 1 -eq 1 ]];do
            echo "Backup GaussDB version [${gaussdb_version}] is inconsistent with Gauss database version [${DB_VERSION}] on the host."
            echo "Are you sure you want to continue?(Y/N):"
            read char
            if [[ "${char}" = "y" || "${char}" = "Y" ]];then
                break
            elif [[ "${char}" = "n" || "${char}" = "N" ]];then
                clear_file
                exit 1
            else
                continue
            fi 
        done
                
    fi
    
    current_dj_version=`cat /opt/huawei/dj/cfg/dj.version | awk 'NR==1'`
    if [[ "${dj_version}" != "${current_dj_version}" ]];then
        while [[ 1 -eq 1 ]];do
            echo "The backup DJ version[$dj_version] and the host DJ version[$current_dj_version] are not consistent!"
            echo "Are you sure you want to continue?(Y/N):"
            read char
            if [[ "${char}" = "y" || "${char}" = "Y" ]];then
                break
            elif [[ "${char}" = "n" || "${char}" = "N" ]];then
                clear_file
                exit 1
            else
                continue
            fi 
        done     
    fi
}

function digital_certificate_restore()
{
    manage_ip=`get_info.py --manage_ip`
    manage_ip_list=`get_info.py --manage_ip list`
    nodes=$(echo ${manage_ip_list}|tr "," "\n")
    for node in ${nodes};do
        if [[  ${manage_ip} == ${node}  ]];then
            sh ${HOME_DIR}/gaussdb_restore.sh -f ${DB_RESTORE_DIR}/digital_certificate.tar.gz
            runlog_and_echo_restore "INFO | Successfully restored digital_certificate on ${node}."
            continue
        fi
        runlog_restore "INFO | copy file to ${node}"
        scp ${SSH_OPT} ${DB_RESTORE_DIR}/digital_certificate.tar.gz djmanager@${node}:/home/djmanager >/dev/null 2>&1
        ssh ${SSH_OPT} djmanager@${node} ${HOME_DIR}/gaussdb_restore.sh -f /home/djmanager/digital_certificate.tar.gz
        runlog_and_echo_restore "INFO | Successfully restored digital_certificate on ${node}."
    done
}

function gaussdb_restore()
{
    manage_ip=`get_info.py --manage_ip`
    primary_node=$(get_primary_db_node)
    #current node is primary node
    if [[ "${manage_ip}" == "${primary_node}" ]];then
        runlog "INFO | current node is the primary."
        sh ${HOME_DIR}/gaussdb_restore.sh -f ${DB_RESTORE_DIR}/rmandatabackup.tar.gz
    else
        runlog_and_echo_restore "INFO | The node to be restored is ${primary_node} ..."
        runlog_restore "INFO | copy file to ${primary_node}"
        scp ${SSH_OPT} ${DB_RESTORE_DIR}/rmandatabackup.tar.gz djmanager@${primary_node}:/home/djmanager/ >>/dev/null 2>&1
        ssh ${SSH_OPT} djmanager@${node} ${HOME_DIR}/gaussdb_restore.sh -f /home/djmanager/rmandatabackup.tar.gz
        runlog_and_echo_restore "INFO | Finish restored on ${primary_node}."
    fi
}

function restore()
{
   while [[ 1 -eq 1 ]];do
        runlog_and_echo_restore "1) restore GaussDB only, 2) restore digital certificate only, 3) restore GaussDB and digital certificate.(1|2|3) "
        read char
        runlog_restore "${char}"
        if [[ "${char}" = "2" ]];then
            digital_certificate_restore
            return 0
        elif [[ "${char}" = "1" ]];then
            gaussdb_restore
            return 0
        elif [[ "${char}" = "3" ]];then
            digital_certificate_restore
            gaussdb_restore
            return 0
        else
            continue
        fi
    done
}

function postrun()
{
    runlog_and_echo_restore "INFO | Begin to start all services..."
    manage_ip_list=`get_info.py --manage_ip list`
    manage_ip=`get_info.py --manage_ip`
    nodes=$(echo ${manage_ip_list}|tr "," "\n")
    for node in ${nodes};do
        runlog_and_echo_restore "INFO | start service on ${node}"
        if [[  ${manage_ip} == ${node}  ]];then
            sh ${HOME_DIR}/serviceControl.sh -start
            if [[ $? -ne 0 ]];then
                runlog_and_echo_restore "INFO | service start up finished on ${node}."
                FAILED_FLAG=1
            else
                runlog_and_echo_restore "INFO | Successfully started services on ${node}."
            fi
            continue
        fi
        ssh ${SSH_OPT} djmanager@${node} ${HOME_DIR}/serviceControl.sh -start
        if [[ $? -ne 0 ]];then
            runlog_and_echo_restore "INFO | service start up finished on ${node}."
            FAILED_FLAG=1
        else
            runlog_and_echo_restore "INFO | Successfully started services on ${node}"
        fi
    done
    if [[ ${FAILED_FLAG} -eq 0 ]];then
        runlog_and_echo_restore "INFO | Successfully started DJ services."
    else
        runlog_and_echo_restore "INFO | DJ service start up finished."
    fi
}

function clear_file()
{
    rm -rf ${RESTORE_DIR}
    rm -f ${SSH_KEY_OUT_FILE}
}


function main()
{
    if [[ ! -f ${BACKUP_FILE_NAME} ]];then
        runlog_and_echo_restore " ERROR | ${BACKUP_FILE_NAME} is not exist, restore GaussDB failed."
        exit 1
    fi
    gen_ssh_key
    prerun
    restore
    postrun
    clear_file
}

case "$1 $#" in
    "-f 2")
        BACKUP_FILE_NAME=$2
        ;;
    *)
        args_err
        break
        ;;
esac
main