#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
source /opt/huawei/dj/inst/bin/utils.sh
CURRENT_DIR=`dirname $(readlink -f $0)`
LOG_DIR='/var/log/huawei/dj/services/system/backup'
LOG_FILE='/var/log/huawei/dj/services/system/backup/backup.log'
KEY="ascagent.backup.backup_conf"
POLICY=`csbs_python -c "from basesdk import cms_info;print(cms_info.get_cms_info(\"${KEY}\"))"`
if [[ -z "${POLICY}" ]];then
    log_error "${KEY} data is empty."
    exit 1
fi
TIME=`csbs_python -c "print(${POLICY}[3].get(\"gaussdb\")[0].get(\"value\"))"`
if [[ -z "${TIME}" ]];then
    log_error "${KEY} time is empty."
    exit 1
fi
time_array=(${TIME//:/ })
hour_str=${time_array[0]}
minute_str=${time_array[1]}
sed -i "/gaussdb_backup_entry.sh/d" /etc/crontab
echo "${minute_str} ${hour_str} * * * root /bin/bash /opt/huawei/dj/bin/backup/backup/gaussdb_backup_entry.sh -a" >> /etc/crontab
service  cron restart