#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

VERSION_PATH="/opt/huawei/dj/versions/"
ZKCLIENT_CONF="/opt/fusionplatform/data/openstack"
KMC_DATA_DIR="/opt/huawei/dj/paas"
KMC_TOOL_DIR="/opt/huawei/dj/bin/kmc"

log_info "Init base script configuration."
[[ ! -L /usr/etc ]] && rm -rf /usr/etc
rm -f /usr/etc && ln -sf /etc /usr/etc
CHECK_RESULT $? "link /etc to /usr/etc failed."
rm -f /usr/opt && ln -sf /opt /usr/opt
CHECK_RESULT $? "link /opt to /usr/opt failed."
csbs_python -m pip install --no-deps --force-reinstall ${LINE_ROOT}/repo/third_party/*.whl
CHECK_RESULT $? "install thirdparty whl failed!"
bash ${LINE_ROOT}/repo/install_base_platfrom.sh
CHECK_RESULT $? "install base platfrom failed."

mkdir -p ${VERSION_PATH}
/usr/bin/cp -f ${LINE_ROOT}/services/base/base.ver ${VERSION_PATH}
mkdir -p ${ZKCLIENT_CONF}
/usr/bin/cp -f ${LINE_ROOT}/conf/zkClient.conf ${ZKCLIENT_CONF}
mkdir -p ${KMC_DATA_DIR}
/usr/bin/cp -f ${LINE_ROOT}/conf/*.txt ${KMC_DATA_DIR}
systemctl restart haveged
log_info "Copy key file to paas."

# kmc初始化之后才能加解密，是故密钥配置放在kmc安装之后
bash  ${LINE_ROOT}/bin/osConfig/ssh_config.sh
/usr/bin/cp -f ${CURRENT_PATH}/rsyslog_base.conf /etc/rsyslog.d/
chmod 600 /etc/rsyslog.d/rsyslog_base.conf
service rsyslog restart
CHECK_RESULT $? "Config ssh and rsyslog failed."

chown -h root:openstack /opt/huawei && chmod 750 /opt/huawei
setprivilege /opt/huawei/dj
setprivilege /opt/fusionplatform
log_info "Chmod chown file or dir."

mkdir -p ${KMC_TOOL_DIR}
/usr/bin/cp -f ${CURRENT_PATH}/kmc_tools/* ${KMC_TOOL_DIR}
chmod 750 -R ${KMC_TOOL_DIR}
sed -i '/kmc_auto_update_master_key.sh/d' /etc/crontab
echo "0 12 * * * root /bin/bash ${KMC_TOOL_DIR}/kmc_auto_update_master_key.sh" >> /etc/crontab
sed -i "/\/kmc_update_master_key.sh/d" /etc/sudoers.d/openstack > /dev/null
echo "%openstack ALL = (root) NOPASSWD:${KMC_TOOL_DIR}/kmc_update_master_key.sh" >> /etc/sudoers.d/openstack
sed -i 's#HISTTIMEFORMAT.*#HISTTIMEFORMAT "%F %T  "#' /etc/profile.d/zzz_euleros_history.sh
log_info "Install base finish."
