#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

IMAGE_VERSION=$(read_microservice_ver ${CURRENT_PATH}/base.ver)
IMAGE_NAME="${LINE_ROOT}/repo/platform/euler/basepythonimage_$(uname -i).tar"
xz -dk "${IMAGE_NAME}.xz"
CHECK_RESULT $? "Unzip basepythonimage failed."
docker ps -a | grep basepythonimage:${IMAGE_VERSION} | awk '{print $1}' | xargs docker rm -f  > /dev/null 2>&1
docker images -q basepythonimage:${IMAGE_VERSION} | xargs docker rmi -f > /dev/null 2>&1
docker import ${IMAGE_NAME} basepythonimage:${IMAGE_VERSION} && rm -f ${IMAGE_NAME}
CHECK_RESULT $? "Import basepythonimage:${IMAGE_VERSION} failed."
docker run -d --privileged --net=host --name=install_base -v ${LINE_ROOT}:/cbs_build basepythonimage:${IMAGE_VERSION} sleep 60000
CHECK_RESULT $? "Run install_base from basepythonimage:${IMAGE_VERSION} failed."
docker exec install_base bash /cbs_build/repo/install_base_platfrom.sh
CHECK_RESULT $? "Run install_base_platfrom.sh in docker failed."
docker commit install_base basepythonimage:${IMAGE_VERSION}
CHECK_RESULT $? "Docker commit install_base basepythonimage:${IMAGE_VERSION} failed."
docker rm -f install_base  > /dev/null 2>&1
exit 0
