#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/base_upgrade.log"

function deploy_uninstall_script()
{
    /usr/bin/cp -f  ${CURRENT_DIR}/../base.yaml  /opt/huawei/dj/inst/services/base/
    /usr/bin/cp -f  ${CURRENT_DIR}/../uninstall.sh  /opt/huawei/dj/inst/services/base/
    /usr/bin/cp -f  ${LINE_ROOT}/bin/utils.sh  /opt/huawei/dj/inst/bin/
    /usr/bin/cp -f  ${LINE_ROOT}/bin/parseyaml.py /opt/huawei/dj/inst/bin/
    /usr/bin/cp -f  ${LINE_ROOT}/bin/pre_install.py /opt/huawei/dj/inst/bin/
    /usr/bin/cp -f  ${LINE_ROOT}/bin/srvmanager.py /opt/huawei/dj/inst/bin/
    /usr/bin/cp -f  ${LINE_ROOT}/bin/uninstall.sh /opt/huawei/dj/inst/
    /usr/bin/cp -f  ${LINE_ROOT}/bin/osConfig/DJserviceControl.sh  /opt/huawei/dj/bin
    /usr/bin/cp -f  ${LINE_ROOT}/bin/osConfig/DJControl.sh  /opt/huawei/dj/bin
    /usr/bin/cp -f  ${CURRENT_DIR}/../rsyslog_base.conf /etc/rsyslog.d/
    /usr/bin/cp -f  ${CURRENT_DIR}/../kmc_tools/* /opt/huawei/dj/bin/kmc
    chown -h root:openstack /opt/huawei && chmod 550 /opt/huawei
    chown -h root:openstack /opt/huawei/dj && chmod 550 /opt/huawei/dj
    SUB_DIR=(inst cfg bin etc inspect paas tools versions)
    for name in ${SUB_DIR[@]};do
        setprivilege "/opt/huawei/dj/${name}"
    done
    chown -h root:openstack /opt/fusionplatform && chmod 550 /opt/fusionplatform
    chown -h root:openstack /opt/fusionplatform/data && chmod 550 /opt/fusionplatform/data
    setprivilege /opt/fusionplatform/data/openstack
}

function set_upgrade_flag()
{
    should_rollback write base
    if [ $? -ne 0 ];then
        log_error "failed to write base upgrade flag"
        return 1
    fi
    log_info "success to write base upgrade flag."
    return 0
}

function load_base_images()
{
    sh ${CURRENT_DIR}/../merge.sh >/dev/null 2>&1
    ret=$?
    if [ ${ret} -ne 0 ];then
        log_error "failed to upgrade base images"
        return 1
    fi
    return 0
}

function backup_files()
{
    mkdir -p ${CURRENT_DIR}/backup_files >> /dev/null 2>&1
    tar -P -czvf ${CURRENT_DIR}/backup_files/get_info.tar.gz /usr/bin/get_info.py >> /dev/null 2>&1
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ]; then
        log_error "backup files failed."
        return 1
    fi
    log_info "backup files sucess."
    return 0
}

function upgrade_tool_script()
{
    /usr/bin/cp -f  ${LINE_ROOT}/bin/get_info.py /usr/bin/get_info.py
    sed -i '/\/kmc_auto_update_master_key.sh/d' /etc/crontab
    sed -i 's/gaussdb_platform_pwd/rabbitmq_pwd/g' /opt/huawei/dj/cfg/sys.ini
    sed -i 's/gaussdb_openstack_pwd/default_user_pwd/g' /opt/huawei/dj/cfg/sys.ini
    echo "0 12 * * * root /bin/bash /opt/huawei/dj/bin/kmc/kmc_auto_update_master_key.sh" >> /etc/crontab
    sed -i "/\/kmc_update_master_key.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/bin/kmc/kmc_update_master_key.sh" >> /etc/sudoers.d/openstack
    rpm -ihv ${LINE_ROOT}/repo/platform/euler/eulervm/*.rpm --force --nodeps >/dev/null 2>&1
    if [[ -f /usr/bin/python3.8 ]];then
        ln -sf /usr/bin/python3.8 /usr/bin/csbs_python
        ln -sf /usr/lib/python3.8 /usr/lib/csbs_python
    else
        rpm -ihv ${LINE_ROOT}/repo/third_party/python-*.rpm --force --nodeps >/dev/null 2>&1
    fi
    [[ ! -L /usr/etc ]] && rm -rf /usr/etc
    rm -f /usr/etc && ln -sf /etc /usr/etc
    CHECK_RESULT $? "link /etc to /usr/etc failed."
    rm -f /usr/opt && ln -sf /opt /usr/opt
    CHECK_RESULT $? "link /opt to /usr/opt failed."
    rpm -e greenlet wrapt
    csbs_python -m pip install --no-deps --force-reinstall ${LINE_ROOT}/repo/third_party/*.whl
    CHECK_RESULT $? "install thirdparty whl failed!"
    bash ${LINE_ROOT}/repo/install_base_platfrom.sh
    CHECK_RESULT $? "install base platfrom failed."
    systemctl restart haveged
    rm -f /etc/sudoers.d/djmanager && touch /etc/sudoers.d/openstack
    chown -h root:openstack /usr/bin/get_info.py && chmod 550 /usr/bin/get_info.py
    chown -h root:openstack /usr/bin/karbor_ping && chmod 550 /usr/bin/karbor_ping
    chown -h root:openstack /usr/bin/python* && chown -h root:openstack /usr/lib*/*python*
    sed -i 's#HISTTIMEFORMAT.*#HISTTIMEFORMAT "%F %T  "#' /etc/profile.d/zzz_euleros_history.sh
    CHECK_RESULT $? "basesdk deploy failed"
}

function set_system_ntp_config()
{
    sed -i '/maxdist/d' /etc/ntp.conf
    sed -i '1 i\tos maxdist 30' /etc/ntp.conf
    if [[ $? -ne 0 ]];then
        log_error "Add maxdist value failed."
        return 1
    fi
    service ntpd restart
    log_info "Add maxdist value successfully."

    cat /etc/crontab | grep "/sbin/hwclock -w"
    if [[ $? -ne 0 ]];then
        sed -i '$a */10 * * * * root /sbin/hwclock -w' /etc/crontab
        if [[ $? -ne 0 ]];then
            log_error "Set hwclock crontab failed."
            return 1
        fi
    fi
    service crond restart
    log_info  "Set hwclock crontab successfully."
    return 0
}

function main()
{
    set_upgrade_flag; CHECK_RESULT $?
    backup_files; CHECK_RESULT $?
    deploy_uninstall_script; CHECK_RESULT $?
    load_base_images; CHECK_RESULT $?
    upgrade_tool_script; CHECK_RESULT $?
    set_system_ntp_config; CHECK_RESULT $? "Set system ntp config failed."
    set_new_version base; CHECK_RESULT $?
}

main
log_info "Upgrade base success."
exit 0