#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

cli_client_conf="/etc/rsyslog.d/rsyslog_cli_client.conf"
KEY="ascagent.common.syslogserver"
ip=$(csbs_python -c "from basesdk import cms_info;print(cms_info.get_cms_info(\"${KEY}\"))")

function log_info()
{
    logger -id -p local1.info -t "cli-client" "INFO" "$1"
}


# set syslog server ip
function set_syslog_server()
{
    log_info "Set syslog server begin. syslog server ip:${ip}."
    count=`grep -c "then @" ${cli_client_conf}`
    if [ ${count} != 0 ]; then
        sed -i "/cli-operate/ s#then @.*#then @${ip}#" ${cli_client_conf}
    else
        sed -i "/cli-operate/ i\if (\$programname == 'cli-operate') then @${ip}" ${cli_client_conf}
    fi
    count_login=`grep -c "authpriv.* @" ${cli_client_conf}`
    if [ ${count_login} != 0 ]; then
        sed -i "/authpriv/ s# @.*# @${ip}#" ${cli_client_conf}
    else
        sed -i "/authpriv/ i\authpriv.* @${ip}" ${cli_client_conf}
    fi

    log_info "set syslog server end."
}

set_syslog_server
service rsyslog restart
if [ "$?" != "0" ];then
    # repeating "systemctl restart xxx" over 6 times in 10 seconds will cause
    # error(start of the service was attempted too often) by default.
    sleep 10
    service rsyslog restart
fi
