#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/cli-client_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ]; then
        log_error "backup cli-client files failed."
        return 1
    fi
    log_info "backup cli-client files success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write cli-client
    if [ $? -ne 0 ];then
        log_error "failed to write cli-client upgrade flag."
        return 1
    fi
    log_info "success to write cli-client upgrade flag."
    return 0
}

function upgrade()
{
    log_info "begin to upgrade cli-client"
    bash $(dirname ${CURRENT_DIR})/uninstall.sh
    bash $(dirname ${CURRENT_DIR})/install.sh
    if [ $? -ne 0 ];then
        return 1
    fi
    log_info "upgrade cli-client finished"
    return 0
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    upgrade; CHECK_RESULT $?
}

main
log_info "upgrade cli-client success."
exit 0