#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
component="cms"
internal_ip=`get_info.py manage_ip`
CMS_LOG_PATH="/var/log/huawei/dj/services/system/cms"
LOG_FILE="${CMS_LOG_PATH}/cmsControl.log"
ServiceState=

function showhelp()
{
    echo "Usage: $prog :"
    echo "  -S ServiceState <RUN|STOP|CHANGE>"
    echo "  -A RESTART"
    echo "  -CS CompontState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "${prog}: illegal option"
    showhelp
    exit 1
}

function stopHeartBeat()
{
    heartBeat STOP cms
    log_info "Stop heartbeat of cms."
}

function heartBeatReg()
{
    heartBeat START cms
    log_info "cms regedit heart beat successfully."
}

function start_cms()
{
    log_info "Begin to start ${component}...."
    queryCmd=$(pgrep -f /usr/bin/cms_server)
    if [ "${queryCmd}" ]; then
        log_info "${component} process is  running, skip."
        return 0
    fi
    proc_manager --start /usr/bin/cms_server
    sleep 3
    queryCmd=$(pgrep -f /usr/bin/cms_server)
    if [ -z "${queryCmd}" ]; then
        log_info "${component} process is  not running, error."
        exit 1
    fi
    log_info "Start ${component} finished."
    return 0
}

function component_run()
{
    log_info "${component}Control: ======component_run begin"
    start_cms
    heartBeatReg
    log_info "${component}Control: ======component_run end"
}

function component_stop()
{
    log_info "${component}Control: ======component_stop begin"
    stopHeartBeat
    queryCmd=$(pgrep -f /usr/bin/cms_server)
    if [ -z "${queryCmd}" ]; then
        log_info "${component} process is not running, skip."
        return 0
    fi
    local nIdx=0
    local retry_times=10
    while [ ${nIdx} -lt ${retry_times} ]
    do
        kill -9 ${queryCmd}
        sleep 1
        queryCmd=$(pgrep -f /usr/bin/cms_server)
        if [ -z "${queryCmd}" ]; then
            break
        fi
        nIdx=$((${nIdx}+1))
    done
    if [ ${nIdx} -ge ${retry_times} ];then
        log_info "${component}Control: ======component_stop failed"
        return 1
    fi
    log_info "Stop component ${component} successfully."
    log_info "${component}Control: ======component_stop end"
}

function component_restart()
{
    log_info "${component}Control: ======component_restart begin"
    component_stop
    component_run
    log_info "${component}Control: ======component_end end"
}

function chown_chmod_log_dir()
{
    mkdir -p ${CMS_LOG_PATH} >/dev/null 2>&1
    chown -h openstack:openstack  ${CMS_LOG_PATH} >/dev/null 2>&1
    chmod 750 ${CMS_LOG_PATH} >/dev/null 2>&1
}


log_info "INFO | #################begin exec cmsControl########################."
chown_chmod_log_dir
while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2;break;;
        -CS) CompStatus=$2;shift 2;break;;
        -A) Action=$2;shift 2;break;;
        -h) showhelp $0;break;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "${Action}" ]; then
    component_restart
elif [ "RUN" = "${ServiceState}" ]; then
    component_run
elif [ "STOP" = "${ServiceState}" ]; then
    component_stop
elif [ "CompontState" = "${CompStatus}" ];then
    sh /opt/huawei/dj/inspect/sh/cms.sh
    exit $?
else
    args_err
fi
exit 0
