#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

db_user_name=$1
read db_user_password
config_file="/opt/huawei/dj/etc/cms/cms.conf"
source /opt/huawei/dj/inst/bin/utils.sh
LOG_FILE=/var/log/huawei/dj/services/system/cms/modify_dbuser.log

cur_password=`cat ${config_file} | grep "^connection" | awk -F ":" '{print $3}' | awk -F "@" '{print $1}'`
sed -i "s/${cur_password}/${db_user_password}/g" ${config_file}
if [ $? -ne 0 ];then
    log_error "Update cms db password config file failed."
    exit 1
fi

cur_account=`cat ${config_file} | grep "connection" | awk -F ":" '{print $2}' | awk -F "//" '{print $2}'`
sed -i "s/${cur_account}/${db_user_name}/g" ${config_file}
if [ $? -ne 0 ];then
    log_error "Update cms db account config file failed."
    exit 1
fi
/usr/bin/cmsControl -A RESTART
if [ $? -ne 0 ];then
    log_error "Retart cms service failed"
    exit 1
fi
log_info "Update cms config file finished."
exit 0