#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

query_cmd=$(pgrep -f /usr/bin/cms_server)
if [[ -z "${query_cmd}" ]]; then
    log_info "Cms server process is not running, start it."
    proc_manager --start /usr/bin/cms_server
fi
log_info "Begin to save ini."
csbs_python -c "from basesdk import cms_info;cms_info.save_ini()"
CHECK_RESULT  $? "Save ini failed."
log_info "Save ini finished."
exit 0