#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/cms_upgrade.log"

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ];then
        log_error "Failed to rollback files."
        return 1
    fi
    log_info "Success to rollback files."
    return 0
}

function rollback_cms()
{
    # rollback container
    cmd_retry "cmsControl -S STOP" 120 5 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Stop cms failed."
        return 1
    fi
    log_info "Stop cms success."
    rollback_files; CHECK_RESULT $?
    cmd_retry "cmsControl -A RESTART" 120 5 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Start cms failed."
        return 1
    fi
    log_info "Start cms success."
    return 0
}

rollback_cms; CHECK_RESULT $?
sed -i '/^cms$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback cms success."
exit 0


