#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
internal_ip=`get_info.py manage_ip`
CPS_LOG_PATH="/var/log/huawei/dj/services/system/cps-monitor"
LOG_FILE="${CPS_LOG_PATH}/cps-monitorControl.log"
SYS_MON_PATH="/usr/bin/sys_monitor"
CPS_MON_PATH="/usr/bin/cps_monitor"
ServiceState=

function showhelp()
{
    echo "Usage: $prog :"
    echo "  -S ServiceState <RUN|STOP>"
    echo "  -A RESTART"
    echo "  -CS CompontState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "${prog}: illegal option"
    showhelp
    exit 1
}

function stopHeartBeat()
{
    heartBeat STOP cps-monitor
    log_info "Stop heartbeat of cps-monitor ret is $?."
}

function heartBeatReg()
{
    heartBeat START cps-monitor
    log_info "Start heartbeat of cps-monitor ret is $?."
}

function start_cps_monitor()
{
    heartBeatReg
    log_info "Begin to start cps_monitor...."
    queryCmd=$(pgrep -f ${CPS_MON_PATH})
    if [[ "${queryCmd}" ]]; then
        log_info "cps_monitor process is  running, skip."
        return 0
    fi
    proc_manager --start ${CPS_MON_PATH}
    sleep 5
    queryCmd=$(pgrep -f ${CPS_MON_PATH})
    if [[ -z "${queryCmd}" ]]; then
        log_info "cps_monitor process is  not running, error."
        stop_cps_monitor
        exit 1
    fi
    queryCmd=$(pgrep -f ${SYS_MON_PATH})
    if [[ "${queryCmd}" ]]; then
        log_info "sys_monitor process is  running, skip."
        return 0
    fi
    proc_manager --start ${SYS_MON_PATH}
    sleep 5
    queryCmd=$(pgrep -f ${SYS_MON_PATH})
    if [[ -z "${queryCmd}" ]]; then
        log_info "sys_monitor process is  not running, error."
        stop_cps_monitor
        exit 1
    fi
    log_info "Start cps_monitor finished."
    return 0
}

function stop_cps_monitor()
{
    stopHeartBeat
    log_info "Begin to stop cps_monitor...."
    kill -9 $(pgrep -f ${SYS_MON_PATH}) >/dev/null 2>&1
    kill -9 $(pgrep -f ${CPS_MON_PATH}) >/dev/null 2>&1
    queryCmd=$(pgrep -f ${SYS_MON_PATH})
    if [[ "${queryCmd}" ]]; then
        log_info "sys_monitor process is running, error."
        exit 1
    fi
    queryCmd=$(pgrep -f ${CPS_MON_PATH})
    if [[ "${queryCmd}" ]]; then
        log_info "cps_monitor process is running, error."
        exit 1
    fi
    log_info "Stop cps_monitor finished."
    return 0
}

function chown_chmod_log_dir()
{
    mkdir -p ${CPS_LOG_PATH} >/dev/null 2>&1
    chown -h openstack:openstack  ${CPS_LOG_PATH} >/dev/null 2>&1
    chmod 750 ${CPS_LOG_PATH} >/dev/null 2>&1
}

function component_status()
{
    pgrep -f /usr/bin/sys_monitor$ >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "sys_monitor not is running"
        exit 1
    fi
    pgrep -f /usr/bin/cps_monitor$ >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "cps_monitor is not running"
        exit 1
    fi
    exit 0
}

log_info "INFO | #################begin exec cps-monitorControl########################."
chown_chmod_log_dir
while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2;break;;
        -A) Action=$2;shift 2;break;;
       -CS) CompStatus=$2;shift 2;break;;
        -h) showhelp $0;break;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "${Action}" ]; then
    stop_cps_monitor
    start_cps_monitor
elif [ "RUN" = "${ServiceState}" ]; then
    start_cps_monitor
elif [ "STOP" = "${ServiceState}" ]; then
    stop_cps_monitor
elif [ "CompontState" = "${CompStatus}" ]; then
    component_status
else
    args_err
fi
exit 0
