#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
sed -i '/^nameserver /d' /etc/resolv.conf

function check_ip(){
    (
        echo "import ipaddress"
        echo "try:"
        echo "    ipaddress.ip_address('$1'.strip())"
        echo "    print('$1'.strip())"
        echo "except ValueError:"
        echo "    print(False)"
    ) | csbs_python
}

for dns_ip in $@;do
    checked_ip=`check_ip ${dns_ip}`
    if [ "${checked_ip}" = "False" ];then
      continue
    fi
    sed -i "\$anameserver ${checked_ip}" /etc/resolv.conf
done