#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
TOOL_PATH="/opt/huawei/dj/tools/services/cps-monitor"
VERSION_PATH="/opt/huawei/dj/versions/"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
CONFIG_PATH="/opt/huawei/dj/etc/cps-monitor"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/cps-monitor"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/cps-monitor.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function create_memory_usage_monitor_conf()
{
    local conf_dir='/opt/huawei/dj/etc/cps-monitor'
    local conf_file="${conf_dir}/memory_usage_monitor.conf"
    mkdir -p "${conf_dir}"
    echo "[default]" > "${conf_file}"
    echo "interval=10" >> "${conf_file}"
    echo "times=360" >> "${conf_file}"
    echo "mem_threshold=0.97" >> "${conf_file}"
    echo "[cps-monitor]"  >> "${conf_file}"
    echo "cafile = /opt/huawei/dj/DJSecurity/server-ca/ca-cert.pem"  >> "${conf_file}"
    setprivilege ${conf_dir}
    sed -i '/resource_monitor.sh/d' /etc/crontab
    echo "-*/1 * * * * root flock -xn /tmp/resource_monitor.lock -c 'bash /opt/huawei/dj/tools/services/cps-monitor/resource_monitor.sh'" >> /etc/crontab
    sed -i '/log_monitor.sh/d' /etc/crontab
    echo "00 */1 * * * root flock -xn /tmp/log_monitor.lock -c 'bash /opt/huawei/dj/tools/services/cps-monitor/log_monitor.sh'" >> /etc/crontab
}

function install_rsyslog()
{
    log_info "install cps-monitor rsyslog conf."
    /usr/bin/cp -f ${CURRENT_PATH}/rsyslog_cpsmonitor.conf /etc/rsyslog.d/
    service rsyslog restart
    if [ $? -ne 0 ];then
        log_info "install cps-monitor rsyslog conf fail."
        sleep 10
        service rsyslog restart
    fi
    log_info "install cps-monitor rsyslog conf success."
    return 0
}

function install()
{
    csbs_python -m pip install --no-deps --force-reinstall  ${LINE_ROOT}/repo/self_developed/cps_monitor*.whl
    CHECK_RESULT $? "pip install cps-monitor failed."
    log_info "install cps-monitor success."
    setprivilege /usr/lib/csbs_python/site-packages
    setprivilege /opt/huawei/dj/etc/cps-monitor

    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege ${TOOL_PATH}
    create_link ${TOOL_PATH}/cps-monitorControl.sh
    log_info "install cps-monitor cli success."

    mkdir -p ${VERSION_PATH} ${CONFIG_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cps-monitor.ver ${VERSION_PATH}
    setprivilege ${VERSION_PATH}
    setprivilege ${CONFIG_PATH}
    log_info "install cps-monitor ver success."

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cps-monitor.sh ${INSPECT_SH_PATH}
    setprivilege ${INSPECT_SH_PATH}
    log_info "install cps-monitor inspect success."
    return 0
}

function set_sudoers_for_cps_monitor()
{
    sed -i "/\/cps-monitorControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/cps-monitor/cps-monitorControl.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/usr/bin/systemctl restart docker.service/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/usr/bin/systemctl restart docker.service" >> /etc/sudoers.d/openstack
    sed -i "/\/update_dns.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/cps-monitor/update_dns.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/update_ntp.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/cps-monitor/update_ntp.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/update_date.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/cps-monitor/update_date.sh" >> /etc/sudoers.d/openstack
}

######################################################################
# 功能说明: 部署场景下重启需要注册cps-monitor心跳的服务，重新注册心跳
# 备   注: cps-monitor依赖zookeeper，zookeeper在cps-monitor之前安装，导致没有注册上心跳，
#         部署完之后没有监控，zookeeper异常后cps-monitor监控无法自动拉起
######################################################################
function restart_dependence_service()
{
    cmd_retry "/usr/bin/zookeeperControl -A RESTART" 3 60 >/dev/null 2>&1
    if [[ $? -ne 0 ]];then
        log_error "Restart zookeeper failed."
        exit 1
    fi
}

deploy_uninstall_script
install
install_rsyslog
create_memory_usage_monitor_conf
set_sudoers_for_cps_monitor
restart_dependence_service
