#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

if [ -f "/usr/bin/cps-monitorControl" ];then
    cps-monitorControl -S STOP
    if [ $? -ne 0 ];then
        log_error "stop cps-monitor failed."
        exit 1
    fi
fi

function uninstall()
{
    ps -ef | grep cps_monitor | awk '{print $2}' | xargs -r kill -9
    rpm -qa | grep -w 'cps-monitor' >/dev/null
    if [ $? -eq 0 ]; then
        log_info "uninstall cps-monitor rpm in this node"
        rpm -e cps-monitor
    fi
    sed -i '/resource_monitor.sh/d' /etc/crontab
    sed -i '/log_monitor.sh/d' /etc/crontab
    service cron restart
    umount -t ramfs /usr/local/bin/cps-monitor/common >> /dev/null 2>&1
    umount -t ramfs /usr/local/bin/cps-monitor/cps_monitor/common >> /dev/null 2>&1
    rm -rf /usr/local/bin/cps-monitor >> /dev/null 2>&1
    rm -f /etc/rsyslog.d/rsyslog_cpsmonitor.conf
    service rsyslog restart
    if [ $? -ne 0 ];then
        log_info "uninstall cps-monitor rsyslog conf fail."
        return 1
    fi
    rm -rf /var/log/huawei/dj/services/system/cps-monitor
    rm /usr/bin/cps-monitorControl
    log_info "uninstall cps-monitor rsyslog conf success."
    log_info "uninstall cps-monitor success."
    exit 0
}

uninstall