#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/cps-monitor_upgrade.log"

function rollback_files()
{
    tar -P -xzvf $LINE_ROOT/services/base/upgrade/backup_files/get_info.tar.gz >> /dev/null 2>&1
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ];then
        log_error "Rollback cps-monitor files failed."
        return 1
    fi
    log_info "Rollback cps-monitor files success."
    return 0
}

function main()
{
    cps-monitorControl -S STOP; CHECK_RESULT $?
    rollback_files; CHECK_RESULT $?
    sed -i 's#{"ascagent": "/opt/huawei/dj/tools/services/ascagent/ascagentControl"},[ ]\{1,2\}##g' /opt/huawei/dj/etc/cps-monitor/command_all.json
    sed -i 's#,[ ]\{1,2\}{"ascagent": "/opt/huawei/dj/tools/services/ascagent/ascagentControl"}##g' /opt/huawei/dj/etc/cps-monitor/command_all.json
    sed -i 's#{"time-sync": "/opt/huawei/dj/tools/services/time-sync/time-syncControl"},[ ]\{1,2\}##g' /opt/huawei/dj/etc/cps-monitor/command_all.json
    sed -i 's#,[ ]\{1,2\}{"time-sync": "/opt/huawei/dj/tools/services/time-sync/time-syncControl"}##g' /opt/huawei/dj/etc/cps-monitor/command_all.json
    sed -i 's#{"keepalived": "/opt/huawei/dj/tools/services/keepalived/keepalivedControl"},[ ]\{1,2\}##g' /opt/huawei/dj/etc/cps-monitor/command_all.json
    sed -i 's#,[ ]\{1,2\}{"keepalived": "/opt/huawei/dj/tools/services/keepalived/keepalivedControl"}##g' /opt/huawei/dj/etc/cps-monitor/command_all.json
    cps-monitorControl -S RUN; CHECK_RESULT $?
}

main
sed -i '/^cps-monitor$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback cps-monitor success."
exit 0