#!/bin/bash
###############################################################
# 功能说明: MO统一证书替换公共方法
# 错误码：
# 1：备份原证书文件失败
# 2：初始化证书文件失败
# 3：替换证书私钥密码文件失败
# 4：替换组件证书失败
# 5：替换组件证书私钥失败
# 6：解密组件证书私钥失败
# 7：校验证书有效性失败
# 8：失败后回退证书失败
# 9：解密证书私钥失败
# 10： 加密证书私钥失败
##############################################################

if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
source /opt/huawei/dj/inst/bin/utils.sh
CURRENT_TOOL=$(readlink -f $0)
SSH_KEY_OUT_FILE="/opt/huawei/dj/DJSecurity/ssh/mo_replace_cert_utils"
SSH_OPT="-o StrictHostKeyChecking=no -i ${SSH_KEY_OUT_FILE}"
BACKUP_PATH='/opt/djbackup/db/manualbk/digital_certificate.tar.gz'
LOG_FILE="/var/log/huawei/dj/services/system/digital_certificate/mo_update_cert.log"
SERVICE_CA_FILE="/opt/huawei/dj/DJSecurity/server-ca/ca-cert.pem"
REPLACE_SERVER="/opt/huawei/dj/DJSecurity/mo_certs/replace_server"

function digital_certificate_backup()
{
    rm -rf ${BACKUP_PATH}
    mkdir -p $(dirname ${BACKUP_PATH})
    tar -P -czvf ${BACKUP_PATH} /opt/huawei/dj/DJSecurity >/dev/null 2>&1
    [[ $? -ne 0 ]] && exit 1
}

function digital_certificate_restore()
{
    for item in ${SUCCESS_NODE};do
        ssh ${SSH_OPT} djmanager@${item} ${CURRENT_TOOL} only_rollback
    done
    tar -P -xzvf ${BACKUP_PATH} >/dev/null 2>&1
    [[ $? -ne 0 ]] && exit 8
    proc_manager --start /usr/bin/DJserviceControl restart
    rm -f ${SSH_KEY_OUT_FILE}
    exit $1
}

function replace_ca()
{
    echo ${CA_CONTENT} | base64 -d > ${SERVICE_CA_FILE}
    if [[ $? -ne 0 ]];then
        log_error "Replace ${SERVICE_CA_FILE} failed."
        digital_certificate_restore 4
    fi
    echo "encrypt_password ${PWD_CONTENT}" > /opt/huawei/dj/DJSecurity/privkey/privkey.conf
    if [[ $? -ne 0 ]];then
        log_error "Replace privkey failed."
        digital_certificate_restore 3
    fi
}

function replace_cert_and_key()
{
    echo ${CERT_CONTENT} | base64 -d > $1
    if [[ $? -ne 0 ]];then
        log_error "Replace $1 failed."
        digital_certificate_restore 5
    fi
    echo ${KEY_CONTENT} | base64 -d > $2
    if [[ $? -ne 0 ]];then
        log_error "Replace $2 failed."
        digital_certificate_restore 6
    fi
    openssl verify -CAfile ${SERVICE_CA_FILE} $1 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Check CA and cert file failed, the replaced certs maybe error."
        digital_certificate_restore 7
    fi
    echo "$3" | openssl rsa -in ${KEY_FILE} -out ${KEY_FILE} -passin stdin
    if [ $? -ne 0 ];then
        log_error "Check key failed, the replaced certs maybe error."
        digital_certificate_restore 9
    fi
    echo "$3" | openssl rsa -aes256 -in ${KEY_FILE} -out ${KEY_FILE} -passout stdin
    if [ $? -ne 0 ];then
        log_error "Config aes256 failed, the replaced certs maybe error."
        digital_certificate_restore 10
    fi
    log_info "Replace $1 and $2 files success."
}

function replace_digital_certificate()
{
    CA_CONTENT=$(cat ${REPLACE_SERVER} | awk '{print $1}')
    CERT_CONTENT=$(cat ${REPLACE_SERVER} | awk '{print $2}')
    KEY_CONTENT=$(cat ${REPLACE_SERVER} | awk '{print $3}')
    PWD_CONTENT=$(cat ${REPLACE_SERVER} | awk '{print $4}')
    export ENCRYPT_DATA=${PWD_CONTENT}
    decrypt_pwd=$(csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")
    digital_certificate_backup
    replace_ca
    COMPONENTS="scagent cli-client cps-monitor omm-ha gaussdb haproxy rabbitmq cms zookeeper karbor resource_manager"
    for COMPONENT in ${COMPONENTS};do
        log_info "Begin to replace ${COMPONENT} certs."
        CERT_FILE=/opt/huawei/dj/DJSecurity/server-cert/${COMPONENT}/${COMPONENT}-cert.pem
        KEY_FILE=/opt/huawei/dj/DJSecurity/server-cert/${COMPONENT}/${COMPONENT}-key.pem
        replace_cert_and_key ${CERT_FILE} ${KEY_FILE} ${decrypt_pwd}
        if [[ "${COMPONENT}" == "haproxy" ]]; then
            cat ${SERVICE_CA_FILE} >> ${CERT_FILE}
            cat ${KEY_FILE} >> ${CERT_FILE}
        fi
    done
    if [[ $# -eq 0 ]];then
        cmd_retry "csbs_python $(dirname ${CURRENT_TOOL})/certs_task_op.py" 30 10
    fi
    proc_manager --start /usr/bin/DJserviceControl restart >/dev/null 2>&1
}

function update_all_nodes()
{
    local cur_node=$(get_info.py manage_ip)
    local node_list=($(get_info.py manage_ip list|sed 's/,/ /g'|sed "s/${cur_node}//g"))
    gen_ssh_key
    for node in ${node_list[@]};do
        ssh ${SSH_OPT} djmanager@${node} ${CURRENT_TOOL} only_local
        ret=$?
        if [[ ${ret} -eq 0 ]]; then
            log_info "Remote update node(${node}) certs success."
            SUCCESS_NODE="${SUCCESS_NODE} ${node}"
            continue
        fi
        log_info "Remote update node(${node}) certs failed."
        for item in ${SUCCESS_NODE};do
            ssh ${SSH_OPT} djmanager@${item} ${CURRENT_TOOL} only_rollback
        done
        rm -f ${SSH_KEY_OUT_FILE}
        exit ${ret}
    done
    replace_digital_certificate
    rm -f ${SSH_KEY_OUT_FILE}
    log_info "All nodes replace certs success."
    exit 0
}


if [[ $# -eq 1 ]] && [[ "$1" == "only_rollback" ]];then
    digital_certificate_restore 0
elif [[ $# -eq 1 ]] && [[ "$1" == "only_local" ]];then
    replace_digital_certificate $@
else
    update_all_nodes
fi