#!/bin/bash
cur_path=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${cur_path}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
root_ca_path="/opt/huawei/dj/DJSecurity/server-ca"
work_cert_path="/opt/huawei/dj/DJSecurity/server-cert"
security_path="/opt/huawei/dj/DJSecurity/"

function get_private_key_pwd()
{
     encrypt_password=$(cat $cur_path/privkey.conf | awk '{print $2}')
     export ENCRYPT_DATA=${encrypt_password}
     csbs_python -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))"
}

private_key_password=$(get_private_key_pwd)
export OPENSSL_CONF=${cur_path}/openssl.cnf
profile=`get_info.py profile`

function create_root_ca()
{
    mkdir -p ${root_ca_path}/demoCA/
    mkdir -p ${root_ca_path}/demoCA/newcerts
    touch ${root_ca_path}/demoCA/index.txt
    rand_serial=`openssl rand -base64 8 | md5sum | cut -c1-8`
    echo "${rand_serial}" > ${root_ca_path}/demoCA/serial
    cd ${root_ca_path}
    openssl genrsa -passout pass:${private_key_password} -out ${root_ca_path}/ca-key.pem -aes256 2048
    if [[ -a ${root_ca_path}/ca-key.pem ]];then
        log_info "create root ca ${root_ca_path} key successfully"
    else
        log_error "create internal ca ${root_ca_path} key failed"
        exit 1
    fi
    openssl req -new -x509 -sha256 -key ${root_ca_path}/ca-key.pem -out ${root_ca_path}/ca-cert.pem -days 3650 -subj "/C=CN/ST=SiChuan/O=Huawei/CN=CBS"  -extensions v3_ca -passin pass:$private_key_password
    log_info "generate root ca certificate finished"
}

function create_key_and_csr()
{
    local cert_name=$1
    local csr_cn=$2
    > ${root_ca_path}/demoCA/index.txt.attr
    log_info "modify unique_subject value"
    echo "unique_subject = no" > ${root_ca_path}/demoCA/index.txt.attr
    openssl genrsa -passout pass:${private_key_password} -aes256 -out ${root_ca_path}/${cert_name}-key.pem 2048
    if [[ ! -a ${root_ca_path}/${cert_name}-key.pem ]]; then
        log_error "there is no cert key for ${csr_cn}"
        exit -1
    fi
    log_info "ready to create ${cert_name} certification request"
    openssl req -new -sha256 -key ${root_ca_path}/${cert_name}-key.pem -out ${root_ca_path}/${cert_name}-csr.pem -days 3650 -subj "/C=CN/ST=SiChuan/O=Huawei/CN=${csr_cn}" -passin pass:${private_key_password}
    if [[ -a ${root_ca_path}/${cert_name}-csr.pem ]];then
        log_info "Create certification request for ${cert_name} successfully."
    else
        log_error "Create certification request for ${cert_name} failed"
        exit 1
    fi
}


function create_work_cert()
{
    local cert_name=$1
    cd ${root_ca_path}
    log_info "ready to sign certification for ${cert_name}"
    openssl ca -batch -in ${root_ca_path}/${cert_name}-csr.pem -cert ${root_ca_path}/ca-cert.pem -keyfile ${root_ca_path}/ca-key.pem -out ${root_ca_path}/${cert_name}-cert.pem -md sha256 -days 3650 -passin pass:${private_key_password}
    if [[ -a ${root_ca_path}/${cert_name}-cert.pem ]];then
        log_info "sign the certification successfully"
    else
        log_info "sign the certification failed"
    fi
    mkdir -p ${work_cert_path}/${cert_name}
    if [[ "${cert_name}" == "haproxy" ]];then
        cat ${root_ca_path}/${cert_name}-key.pem >> ${root_ca_path}/${cert_name}-cert.pem
        cat ${cur_path}/DJSecurity/Huawei_IT_Product_CA.cer >> ${root_ca_path}/${cert_name}-cert.pem
    fi
    mv  ${root_ca_path}/${cert_name}-cert.pem ${work_cert_path}/${cert_name}/
    mv  ${root_ca_path}/${cert_name}-key.pem ${work_cert_path}/${cert_name}/
    rm -rf ${root_ca_path}/${cert_name}-csr.pem
}

function generate_certificate()
{
    COMPONENTS="scagent cli-client cps-monitor omm-ha gaussdb haproxy rabbitmq cms zookeeper karbor resource_manager"
    for COMPONENT in ${COMPONENTS};do
        if [ "${COMPONENT}" = "gaussdb" ];then
            float_ip=`get_info.py gaussdb_float_ip`
        else
            float_ip=`get_info.py haproxy_float_ip`
        fi
        create_key_and_csr ${COMPONENT} ${float_ip}
        create_work_cert ${COMPONENT}
    done

}
function config_internal()
{
    mkdir -p ${security_path}/privkey
    cp ${cur_path}/privkey.conf ${security_path}/privkey
    mkdir -p ${security_path}/ssh/
    mkdir -p ${security_path}/ftps-ca/
    touch ${security_path}/ssh/known_hosts
    rm -rf ${security_path}/server-ca/demoCA
    setprivilege ${security_path}
}

function sync_root_ca()
{
    local security_path='/opt/huawei/dj/DJSecurity'
    node_list=$(get_info.py manage_ip list)
    cur_nodo=$(get_info.py manage_ip)
    for node in ${node_list//,/ }; do
        if [[ "${cur_nodo}" == "${node}" ]];then
            continue
        fi
        log_info "begin to sync ca to ${node}"
        scp_times=0
        while [[ ${scp_times} -lt 360 ]]
        do
            scp -o StrictHostKeyChecking=no -i /home/djmanager/.ssh/id_rsa -r ${security_path}/server-ca djmanager@[${node}]:/home/djmanager
            if [ $? -eq 0 ];then
                log_info "sync ca to ${node} successfully."
                break
            fi
            log_warn "failed to sync ca to ${node},retry: ${scp_times}."
            sleep 5
            let "scp_times++"
        done
        rm -rf /home/djmanager/server-ca
        if [[ ${scp_times} == 360 ]];then
            log_error "sync ca file failed."
            return 1
        fi
    done
    return 0
}


function main()
{
    mkdir -p ${security_path}
    get_private_key_pwd
    node_index=$(get_info.py node_index)
    if [ "${node_index}" = "1" ];then
        create_root_ca
        sync_root_ca; CHECK_RESULT $? "Sync root ca failed!"
    else
        wait_times=0
        while [[ ${wait_times} -lt 360 ]]
        do
            if [ -f /home/djmanager/server-ca/ca-cert.pem ];then
                log_info "root ca is existed."
                break
            fi
            log_info "waiting sync root ca..."
            sleep 5
            let "wait_times++"
        done
        if [[ ${wait_times} == 360 ]];then
            log_error "waiting timeout."
            exit 1
        fi
        /usr/bin/cp -rf /home/djmanager/server-ca ${security_path}
        rm -rf /home/djmanager/server-ca
    fi
    generate_certificate
    config_internal
}

main
