#!/bin/bash

CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
TOOL_PATH="/opt/huawei/dj/tools/services/"
UPGRADE_FLAG="$1"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/digital_certificate"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/digital_certificate.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function install()
{
    if [[ "${UPGRADE_FLAG}" != "upgrade" ]];then
        log_info "begin to create certs... "
        sh ${CURRENT_PATH}/create_cert.sh
        CHECK_RESULT "$?" "create certs failed.."
    else
        log_info "begin to add resource_manager certs... "
        server_cert=/opt/huawei/dj/DJSecurity/server-cert
        mkdir -p ${server_cert}/resource_manager
        /usr/bin/cp -f ${server_cert}/karbor/karbor-cert.pem ${server_cert}/resource_manager/resource_manager-cert.pem
        /usr/bin/cp -f ${server_cert}/karbor/karbor-key.pem ${server_cert}/resource_manager/resource_manager-key.pem
    fi

    log_info "begin to copy bin script ... "
    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -rf ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/digital_certificate/*.sh
    chmod 550 ${TOOL_PATH}/digital_certificate/*.py
    setprivilege ${TOOL_PATH}

    sed -i '/check_certificate_date.sh/d' /etc/crontab
    echo "0 */6 * * * root /bin/bash  ${TOOL_PATH}/digital_certificate/check_certificate_date.sh >/dev/null 2>&1" >> /etc/crontab
    log_info "Upgrade certs replace scripts successfully."

    /usr/bin/cp -f ${CURRENT_PATH}/digital_certificate.ver /opt/huawei/dj/versions/
    setprivilege /opt/huawei/dj/versions/

    chown -hR root:root /opt/huawei/dj/DJSecurity
    setprivilege /opt/huawei/dj/DJSecurity
}

function set_sudoers_for_digital_certificate()
{
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/digital_certificate/mo_replace_certs.sh" >> /etc/sudoers.d/openstack
    sed -i "/\/bin\/DJControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/bin/DJControl.sh" >> /etc/sudoers.d/openstack
}

deploy_uninstall_script
install
set_sudoers_for_digital_certificate
exit 0