#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/digital_certificate_upgrade.log"

function set_upgrade_flag()
{
    should_rollback write digital_certificate
    if [[ $? -ne 0 ]];then
        log_error "Write digital_certificate upgrade flag failed."
        return 1
    fi
    log_info "Write digital_certificate upgrade flag successfully."
    return 0
}

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [[ $? -ne 0 ]]; then
        log_error "Backup files failed."
        return 1
    fi
    log_info "Backup files successfully."
    return 0
}

function main()
{
    backup_files
    set_upgrade_flag
    rm -rf /opt/huawei/dj/bin/digital_certificate >/dev/null 2>&1
    bash ${CURRENT_DIR}/../install.sh "upgrade">/dev/null 2>&1
    set_new_version digital_certificate; CHECK_RESULT $?
}

main
log_info "upgrade digital_certificate success."
exit 0