#!/bin/sh
gaussdb_script_logfile="/var/log/fusionsphere/component/gaussdb/script.log"
mkdir -p $(dirname ${gaussdb_script_logfile})
touch  ${gaussdb_script_logfile}
chown -hR gaussdba:dbgrp $(dirname ${gaussdb_script_logfile})

function hcp_script_log()
{
    local datetime=`date +"%y-%m-%d %H:%M:%S"`
    local curUser=`whoami`
    local curScript=$1   
    if [ -z "$2" ]
    then
        loglevel="INFO"
    else
        loglevel=$2
    fi
    local message=$3
    printf "[$datetime][$curScript][$loglevel][$curUser]  $message\n" >> "$gaussdb_script_logfile" 2>/dev/null
}

function log_error()
{
    hcp_script_log "${0##*/}" "ERROR" "$*"
}

function log_info()
{
    hcp_script_log "${0##*/}" "INFO " "$*" 
}

function log_debug()
{
     hcp_script_log "${0##*/}" "DEBUG" "$*"
}

function log_warn()
{
    hcp_script_log "${0##*/}" "WARN " "$*"
}
