#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
DB_SYNC_CONF_PATH="/opt/huawei/dj/etc/gaussdb/"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
VERSION_PATH="/opt/huawei/dj/versions/"
UPGRADE_FLAG="$1"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/gaussdb"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/gaussdb.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}

function install()
{
    if [[ "${UPGRADE_FLAG}" != "upgrade" ]];then
        mkdir -p /opt/fusionplatform/data/
        tar xf ${LINE_ROOT}/repo/platform/gaussdb/gaussdb_data.tar.gz -C /opt/fusionplatform/data/
        mv /opt/fusionplatform/data/data /opt/fusionplatform/data/gaussdb
        /usr/bin/cp -f ${CURRENT_PATH}/postgresql.conf /opt/fusionplatform/data/gaussdb
        CHECK_RESULT $? "Failed to install gaussdb data rpm in  host."
    fi

    log_info "Install gaussdb data rpm in host."
    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/gaussdb.ver ${VERSION_PATH}
    setprivilege ${VERSION_PATH}
    log_info "Copy gaussdb.ver to ${VERSION_PATH}."

    mkdir -p ${INSPECT_SH_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/inspect/gaussdb.sh ${INSPECT_SH_PATH}
    setprivilege ${INSPECT_SH_PATH}
    log_info "Copy gaussdb.sh to ${INSPECT_SH_PATH}."

    mkdir -p ${DB_SYNC_CONF_PATH}/archive/
    if [[ "${UPGRADE_FLAG}" != "upgrade" ]];then
        sed -i "s/^sync_time=.*/sync_time=$(date +%s)/g" ${CURRENT_PATH}/db_sync.conf
        /usr/bin/cp -f ${CURRENT_PATH}/db_sync.conf ${DB_SYNC_CONF_PATH}
    fi

    /usr/bin/cp -f ${CURRENT_PATH}/sync_monitor.sh ${DB_SYNC_CONF_PATH}
    chown -hR root:openstack ${DB_SYNC_CONF_PATH}
    chmod 750 ${DB_SYNC_CONF_PATH}/sync_monitor.sh
    chmod 640 ${DB_SYNC_CONF_PATH}db_sync.conf
    chown -hR gaussdba:dbgrp ${DB_SYNC_CONF_PATH}/archive
}

deploy_uninstall_script
install
exit $?