#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
SERV_IMG_NAME="gaussdb"
SERV_IMG_VERSION=`read_microservice_ver /opt/huawei/dj/versions/gaussdb.ver`
LOG_FILE="/var/log/huawei/dj/services/system/ha/script.log"
GAUSSBD_IMG="${SERV_IMG_NAME}:${SERV_IMG_VERSION}"
DOCKER_GAUSSDB_CONTROL="/home/gaussdbControl.sh"
ALARM_RECORD="/opt/huawei/dj/etc/gaussdb/alarm_record"
ALARM_SCRIPT="/opt/omm/oma/tools/sendAlarm"
MAX_ALARM_TIMES=120
MAX_RECOVER_TIMES=120


function main_in_container()
{
    log_info "${DOCKER_GAUSSDB_CONTROL} ${optCommand} ${runState} ${nextState} ${haName} ****"
    docker exec -u root ${SERV_IMG_NAME} bash -c "${DOCKER_GAUSSDB_CONTROL} ${optCommand} ${runState} ${nextState} ${haName}"
    return $?
}


function _send_alarm()
{
    local now=$(date +%s)
    local host_name=$(get_info.py hostname)
    local host_ip=$(get_info.py manage_ip)
    ${ALARM_SCRIPT} 1020715 $1 1 "" "${now}" "GaussDB" "sync" "${host_name}" "${host_ip}"
}


function send_sync_alarm()
{
    sed -ri "/recover_times=[0-9]+/d" "${ALARM_RECORD}"
    local alarm_times=$(grep "alarm_times" "${ALARM_RECORD}" | awk -F "=" '{print $2}')
    if [[ -z ${alarm_times} ]];then
        log_info "Database sync failed 1 times."
        echo "alarm_times=1" >> "${ALARM_RECORD}"
        return
    fi
    if [[ ${alarm_times} -eq ${MAX_ALARM_TIMES} ]];then
        log_info "Database sync failed ${alarm_times} times, send alarm."
        _send_alarm 0
        sed -ri "/alarm_times=[0-9]+/d" "${ALARM_RECORD}"
        return
    fi
    let "alarm_times++"
    sed -ri "s/(alarm_times=)[0-9]+/\1${alarm_times}/g" "${ALARM_RECORD}"
    log_info "Database sync failed ${alarm_times} times."
}


function recover_sync_alarm()
{
    sed -ri "/alarm_times=[0-9]+/d" "${ALARM_RECORD}"
    local recover_times=$(grep "recover_times" "${ALARM_RECORD}" | awk -F "=" '{print $2}')
    if [[ -z ${recover_times} ]];then
        log_info "Database sync succeed 1 times."
        echo "recover_times=1" >> "${ALARM_RECORD}"
        return
    fi
    if [[ ${recover_times} -eq ${MAX_RECOVER_TIMES} ]];then
        log_info "Database sync succeed ${recover_times} times, send recover."
        _send_alarm 1
        sed -ri "/recover_times=[0-9]+/d" "${ALARM_RECORD}"
        return
    fi
    let "recover_times++"
    sed -ri "s/(recover_times=)[0-9]+/\1${recover_times}/g" "${ALARM_RECORD}"
    log_info "Database sync succeed ${recover_times} times."
}

function check_and_reset_status()
{
    if [[ ! -f "${ALARM_RECORD}" ]];then
        touch "${ALARM_RECORD}"
    fi
    bash /opt/huawei/dj/etc/gaussdb/sync_monitor.sh safe_reset_status >> ${LOG_FILE} 2>&1
    local ret=$?
    log_info "Check db sync: ret=${ret}, runState=${runState}."
    if [[ ${ret} -ne 0 ]];then
        send_sync_alarm
    else
        recover_sync_alarm
    fi
    if [[ ${ret} -ne 0 ]] && [[ ${runState} == "active" ]];then
       # 当前节点已无法自动升主，尝试切换主备
       /usr/local/bin/ha/ha/module/hacom/tools/ha_client_tool --switchover  --name=forceswap
       exit 0
    fi
}

function start_gaussdb_container()
{
    log_info "Start gaussdb container"
    local docker_security_opt="--memory 6144m --cpu-shares 1024 --ulimit nofile=2048:2048 --security-opt=no-new-privileges --pids-limit 4096"
    docker rm -f ${SERV_IMG_NAME} >/dev/null 2>&1
    docker run -d --net=host --name ${SERV_IMG_NAME} \
        -v /opt/fusionplatform/data/gaussdb:/opt/fusionplatform/data/gaussdb \
        -v /var/log/huawei/dj/services/system/gaussdb:/var/log/fusionsphere/component/gaussdb \
        -v /opt/huawei/dj/DJSecurity/privkey:/opt/huawei/dj/DJSecurity/privkey \
        -v /opt/huawei/dj/paas:/opt/huawei/dj/paas \
        -v /opt/huawei/dj/cfg:/opt/huawei/dj/cfg:ro \
        -v /opt/huawei/dj/etc/gaussdb:/opt/huawei/dj/etc/gaussdb \
        -v /etc/localtime:/etc/localtime:ro \
        -v /var/log/huawei/dj/services/system/kmc:/var/log/huawei/dj/services/system/kmc \
        ${docker_security_opt} \
        ${GAUSSBD_IMG} bash /home/start_gaussdb.sh >/dev/null 2>&1
    local gaussdbCertPath="/opt/fusionplatform/data/cert"
    local cert_path="/opt/huawei/dj/DJSecurity/server-cert/gaussdb"
    local ca_path="/opt/huawei/dj/DJSecurity/server-ca/"
    docker cp -a ${ca_path}/ca-cert.pem        ${SERV_IMG_NAME}:${gaussdbCertPath}/ca-cert.pem
    docker cp -a ${cert_path}/gaussdb-cert.pem ${SERV_IMG_NAME}:${gaussdbCertPath}/server.crt
    docker cp -a ${cert_path}/gaussdb-cert.pem ${SERV_IMG_NAME}:${gaussdbCertPath}/client.crt
    docker cp -a ${cert_path}/gaussdb-key.pem  ${SERV_IMG_NAME}:${gaussdbCertPath}/server.key
    docker cp -a ${cert_path}/gaussdb-key.pem  ${SERV_IMG_NAME}:${gaussdbCertPath}/client.key
    rm -rf /opt/fusionplatform/data/gaussdb/*.key.*
}

function stop_gaussdb_container()
{
    log_info "Stop gaussdb container"
    docker stop ${SERV_IMG_NAME} >/dev/null 2>&1
    docker rm -f ${SERV_IMG_NAME} >/dev/null 2>&1
    return 0
}

function main()
{
    if [ ! -f "/opt/huawei/dj/versions/gaussdb.ver" ];then
        exit 0
    fi
    local container_id=$(docker ps -q -f name=${SERV_IMG_NAME})
    if [[ "${container_id}X" == "X" ]];then
        start_gaussdb_container
    fi
    local -i retVal=0
    case "${optCommand}" in
    status)
        main_in_container; retVal=$?
        check_and_reset_status
        return ${retVal}
        ;;
    start)
        main_in_container; retVal=$?
        return ${retVal}
        ;;
    stop)
        stop_gaussdb_container; retVal=$?
        return ${retVal}
        ;;
    force-stop)
        stop_gaussdb_container; retVal=$?
        return ${retVal}
        ;;
    active)
        main_in_container; retVal=$?
        return ${retVal}
        ;;
    deactive)
        main_in_container; retVal=$?
        return ${retVal}
        ;;
    repair)
        main_in_container; retVal=$?
        return ${retVal}
        ;;
    *)
        log_warn "Operation(${optCommand}) not support."
        return 10
        ;;
    esac
}

declare optCommand="$1"; shift
declare runState="$1";  shift
declare selfParam="$1"; shift
declare nextState="$1"; shift
declare haName="$1";    shift
declare -i scriptRetVal=0

main ; scriptRetVal=$?
exit ${scriptRetVal}
