#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

GAUSSDB_IMAGE_NAME="gaussdb"
container_id=$(docker ps -a | grep ${GAUSSDB_IMAGE_NAME} | grep -v grep | awk '{print $1}')

function stop_gaussdb()
{
    docker rm -f gaussdb >/dev/null 2>&1
    return $?
}

function _delete_image_impl()
{
    local images=`docker images -a -q ${GAUSSDB_IMAGE_NAME}`
    if [ "$?" == "0" ] && [ -z "${images}" ];then
        return 0
    fi
    docker rmi -f ${images} >/dev/null 2>&1
    if [ "$?" != "0" ];then
        return 1
    fi
    return 0
}

function uninstall()
{
    rm -rf /usr/local/bin/ha/ha/config_script >/dev/null 2>&1
    rm -rf /opt/huawei/dj/tools/services/gaussdb/ >/dev/null 2>&1
    for (( i=0; i<10; i++  ));do
        _delete_image_impl
        if [ $? -ne 0 ];then
            sleep 1
            continue
        fi
        return 0
    done
    return 1
}

stop_gaussdb
uninstall
exit $?