#! /bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/gaussdb_upgrade.log"

function rollback_files()
{
    backup_or_rollback rollback ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ];then
        log_error "Failed to rollback files."
        return 1
    fi
    log_info "Success to rollback files."
    return 0
}

function rollback_gaussdb_container()
{
    # rollback container
    # 1.停止omm-ha, 2.删除容器镜像,3.回滚镜像,4.启动ha,5.检查gaussdb状态
    cmd_retry "omm-haControl -S STOP" 120 5 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Stop omm-ha failed."
        return 1
    fi
    log_info "Stop omm-ha success."
    cmd_retry "docker rm -f gaussdb" 10 5 >/dev/null 2>&1
    check_container=`docker ps -a | grep gaussdb | wc -l`
    if [ ${check_container} -ne 0 ];then
        log_error "Remove container failed."
        return 1
    fi
    log_info "Remove container success."
    new_version=$(read_microservice_ver ${LINE_ROOT}/services/gaussdb/gaussdb.ver)
    remove_image "gaussdb:${new_version}"; CHECK_RESULT $?
    rollback_files; CHECK_RESULT $?
    rollback_image ${CURRENT_DIR}/backup_files/ "gaussdb"
    if [ $? -ne 0 ];then
        log_error "Error to rollback gaussdb image."
        return 1
    fi
    log_info "Rollback guassdb image success."
    cmd_retry "omm-haControl -A RESTART" 120 5 >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Start omm-ha failed."
        return 1
    fi
    log_info "Start omm-ha success."
    return 0
}

rollback_gaussdb_container; CHECK_RESULT $?
sed -i '/^gaussdb$/d' ${LINE_ROOT}/should_rollback.dat
log_info "Rollback gaussdb success."
exit 0
