#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

source /opt/huawei/dj/inst/bin/utils.sh
HAPROXY_LOG_PATH="/var/log/huawei/dj/services/system/haproxy"
LOG_FILE="${HAPROXY_LOG_PATH}/haproxyinternalControl.log"
SERV_IMG_VERSION=`read_microservice_ver /opt/huawei/dj/versions/haproxy.ver`
component="haproxyinternal"
ServiceState=


function showhelp()
{
    echo "Usage: $component :"
    echo "  -S ServiceState <RUN|STOP|CHANGE>"
    echo "  -A RESTART"
    echo "  -CS CompontState"
    echo "  -h show this help"
    exit 1
}

function args_err()
{
    echo -e "$component: illegal option"
    showhelp
    exit 1
}

function stopHeartBeat()
{
    heartBeat STOP haproxy
    log_info "Stop heartbeat of haproxy."
}

function heartBeatReg()
{
    heartBeat START haproxy
    log_info "haproxy regedit heart beat successfully."
}

function check_start()
{
    #check status
    succ_num=0
    log_info "Begin to check status of ${component}..."
    for ((nIdx=0; nIdx<20; nIdx++))
    do
        proc_num=`ps -ef|grep 'haproxy/bin/haproxy_run.sh' | grep -v heartBeat | wc -l`
        if [ ${proc_num} -gt 0 ];then
            succ_num=$((${succ_num}+1))
            if [ ${succ_num} -ge 5 ];then
                log_info "Check status of ${component} ok."
                return 0
            fi
        else
            succ_num=0
        fi
        sleep 2
    done
    log_error "Check status of ${component} failed."
    exit 1
}

function start_haproxy()
{
    log_info "Begin to start ${component}...."
    #if has container instance, start it or skip
    ret_info=`docker ps -q -f name=${component}`
    CHECK_RESULT $? "Get docker info of ${component} failed."
    if [ ! -z "${ret_info}" ];then
        log_info "Container ${component} is running, skip."
        return 0
    fi
    ret_info=`docker ps -a -q -f name=${component}`
    CHECK_RESULT $? "Get docker info of ${component} failed."
    if [ ! -z  "${ret_info}" ];then
        log_info "Try to start ${component}..."
        local retry_times=0
        while [ ${retry_times} -lt 3 ]
        do
            docker start ${component}
            if [ $? -eq 0 ];then
                check_start
                return 0
            else
                log_error "Try to start ${component} failed, retry..."
                local c_id=`docker ps -a -q --no-trunc -f name=${component}`
                if [ $? -eq 0 -a -n "${c_id}" ];then
                    rm -rf "/run/containerd/${c_id}"
                    rm -rf "/var/run/runc/${c_id}"
                fi
                sleep 1
            fi
            retry_times=$((${retry_times} + 1))
        done
        log_error "Start ${component} failed."
        exit 1
    fi
    #no instance
    log_info "There is no ${component} container instance, run new one."
    local haproxy_cfg_path="/opt/huawei/dj/etc/haproxy"
    local haproxy_cert_path="/opt/huawei/dj/DJSecurity"
    local docker_security_opt="--memory 1024m --cpu-shares 1024 --ulimit nofile=2048:2048 --pids-limit 1024 --security-opt=no-new-privileges"
    docker run                                          \
        -v /etc/localtime:/etc/localtime:ro             \
        -v /etc/resolv.conf:/etc/resolv.conf:ro         \
        -v /opt/huawei/dj/paas:/opt/huawei/dj/paas:ro   \
        -v ${haproxy_cfg_path}:${haproxy_cfg_path}:ro   \
        -v ${haproxy_cert_path}:${haproxy_cert_path}:ro   \
        -v /usr/bin/get_info.py:/usr/bin/get_info.py:ro \
        -v /opt/huawei/dj/cfg:/opt/huawei/dj/cfg:ro  \
        -v /opt/fusionplatform/data/openstack/:/opt/fusionplatform/data/openstack \
        -v /var/log/huawei/dj/services/system/kmc:/var/log/huawei/dj/services/system/kmc \
        --detach                                        \
        --net=host                                      \
        --name ${component}                             \
        ${docker_security_opt}                          \
        haproxy:${SERV_IMG_VERSION}            \
        bash /etc/huawei/dj/haproxy/bin/haproxy_run.sh >/dev/null 2>&1
    CHECK_RESULT $? "Start container ${component} failed."
    log_info "Start ${component} finished."

    check_start
}

function component_run()
{
    log_info "${component}Control: ======component_run begin"
    start_haproxy
    heartBeatReg
    log_info "${component}Control: ======component_run end"
}

function component_stop()
{
    log_info "${component}Control: ======component_stop begin"
    stopHeartBeat
    
    ret_info=`docker ps -a -q -f name=${component}`
    CHECK_RESULT $? "Get docker info of ${component} failed."
    
    if [ -z "${ret_info}" ];then
        log_info "There is no container instance, skip."    
    else
        docker stop ${component}
        CHECK_RESULT $? "Stop component ${component} failed."    
    fi

    log_info "Stop component ${component} successfully."
    log_info "${component}Control: ======component_stop end"
}

function component_restart()
{
    log_info "${component}Control: ======component_restart begin"
    component_stop
    component_run
    log_info "${component}Control: ======component_end end"
}

function checkRun()
{
    sh /opt/huawei/dj/inspect/sh/haproxy.sh haproxyinternal
    exit $?
}

function chown_chmod_log_dir()
{
    mkdir -p ${HAPROXY_LOG_PATH} >/dev/null 2>&1
    chown -h openstack:openstack  ${HAPROXY_LOG_PATH} >/dev/null 2>&1
    chmod 750 ${HAPROXY_LOG_PATH} >/dev/null 2>&1
}

log_info "INFO | #################begin exec haproxyinternalControl########################."
chown_chmod_log_dir
while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2;break;;
        -CS) CompStatus=$2;shift 2;break;;
        -A) Action=$2;shift 2;break;;
        -h) showhelp $0;break;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "${Action}" ]; then
    component_restart
elif [ "RUN" = "${ServiceState}" ]; then
    component_run
elif [ "STOP" = "${ServiceState}" ]; then
    component_stop
elif [ "CHANGE" = "${ServiceState}" ]; then
    component_restart
elif [ "CompontState" = "${CompStatus}" ];then
    checkRun
else
    args_err
fi

exit 0
