#!/bin/bash
. /etc/huawei/dj/haproxy/bin/utils.sh

log_error()
{
    logger -id -n localhost -p local1.error -t haproxyrun "$1"
}

log_info()
{
    logger -id -n localhost -p local1.info -t haproxyrun "$1"
}

log_info "Begin to generate config file."

HAPROXY_CFG_DIR="/etc/huawei/dj/haproxy/cfg/"
HAPROXY_TMP_CFG="/etc/huawei/dj/haproxy/tmp/haproxy.cfg"
rm -f ${HAPROXY_TMP_CFG}

#export haproxy config
log_info "Begin to export hapoxy config to file ${HAPROXY_TMP_CFG}..."
function haproxy_regist_export()
{
    local count=120
    while [[ ${count} -gt 0 ]];do
        rm -f $1
        /usr/bin/haproxy_regist export --file-name $1
        if [[ $? -eq 0 && -f $1 ]];then
            return 0
        fi
        let count--
        sleep 5s
    done
    log_error "Export haproxy config file failed."
    exit 1
}
haproxy_regist_export ${HAPROXY_TMP_CFG}


#replace variables
log_info "Begin to replace variables of file ${HAPROXY_TMP_CFG}..."
HAPROXY_FLOAT_IP=$(get_info.py haproxy_float_ip)
sed -i "s/\${manage}/${HAPROXY_FLOAT_IP}/g" ${HAPROXY_TMP_CFG}
sed -i "s/\${tenant}/${HAPROXY_FLOAT_IP}/g" ${HAPROXY_TMP_CFG}
sed -i "s/\${internal}/${HAPROXY_FLOAT_IP}/g" ${HAPROXY_TMP_CFG}
chmod 640 ${HAPROXY_TMP_CFG}

#check with haproxy
log_info "Begin to check config file ${HAPROXY_TMP_CFG}..."
check_haproxy_with_key "${HAPROXY_TMP_CFG}"
if [[ $? -ne 0 ]];then
    log_error "Check config file ${HAPROXY_TMP_CFG} failed."
    exit 1
fi

mv ${HAPROXY_TMP_CFG} ${HAPROXY_CFG_DIR}
if [[ $? -ne 0 ]];then
    log_error "Move ${HAPROXY_TMP_CFG} to ${HAPROXY_CFG_DIR} failed."
    exit 1
fi
log_info "Generate config file successfully."
