#!/bin/bash
source /etc/huawei/dj/haproxy/bin/utils.sh

log_error()
{
    logger -id -n localhost -p local1.error -t haproxyrun "$1"
}

log_info()
{
    logger -id -n localhost -p local1.info -t haproxyrun "$1"
}

log_info "Begin to start haproxy."
HAPROXY_ROOT_PATH='/etc/huawei/dj/haproxy'
HAPROXY_BIN_DIR="${HAPROXY_ROOT_PATH}/bin"
HAPROXY_CFG_DIR="${HAPROXY_ROOT_PATH}/cfg"
HAPROXY_CERT='/opt/huawei/dj/DJSecurity/server-cert/haproxy/haproxy-cert.pem'

#creae config file
log_info "Begin to create haproxy config file."
flock -w 10 -E 1 -x /tmp/haproxy_regist.lock -c "bash /etc/huawei/dj/haproxy/bin/generage_conf.sh"
if [[ $? -ne 0 ]];then
    log_error "Generate haproxy config file failed."
    exit 1
fi

while true;do
    #haproxy
    haproxy_num=$(pgrep -f /usr/sbin/haproxy)
    if [[ -z "${haproxy_num}" ]];then
        log_info "Begin to start haproxy."
        start_haproxy_with_key "${HAPROXY_CFG_DIR}/haproxy.cfg" "${HAPROXY_CFG_DIR}/haproxy.pid"
    fi
    watcher_num=$(pgrep -f  ${HAPROXY_BIN_DIR}/haproxy_watcher.py)
    if [[ -z ${watcher_num} ]];then
        log_info "Begin to start haproxy watcher."
        proc_manager --start  ${HAPROXY_BIN_DIR}/haproxy_watcher.py
    fi
    sleep 60s
done
