#!/bin/bash

function get_password() {
    local private_key='/opt/huawei/dj/DJSecurity/privkey/privkey.conf'
    local key=$(cat "${private_key}" | awk '{print $2}')
    export ENCRYPT_DATA="${key}"
    csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0))"
}

function start_haproxy_with_key() {
    local cfg_path=$1
    local pid_path=$2
    local key=$(get_password)
    /usr/bin/expect<<-EOF
#!/usr/bin/expect

set timeout 600
proc start_haproxy {} {
    spawn /usr/sbin/haproxy -D -f "${cfg_path}" -p "${pid_path}"
    expect {
        "Enter PEM pass phrase:" {
            send "${key}\r"
            exp_continue
        }
        eof { }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
}

start_haproxy
EOF
}

function reload_haproxy_with_key() {
    local cfg_path=$1
    local pid_path=$2
    local pid=$3
    local key=$(get_password)
    /usr/bin/expect<<-EOF
#!/usr/bin/expect

set timeout 600
proc reload_haproxy {} {
    spawn /usr/sbin/haproxy -D -f "${cfg_path}" -p "${pid_path}" -sf ${pid}
    expect {
        "Enter PEM pass phrase:" {
            send "${key}\r"
            exp_continue
        }
        eof { }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
}

reload_haproxy
EOF
}

function check_haproxy_with_key() {
    local cfg_path=$1
    local key=$(get_password)
    /usr/bin/expect<<-EOF
#!/usr/bin/expect

set timeout 600
proc check_haproxy {} {
    spawn /usr/sbin/haproxy -c -f ${cfg_path} -q
    expect {
        "Enter PEM pass phrase:" {
            send "${key}\r"
            exp_continue
        }
        eof { }
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
}

check_haproxy
EOF
}
