#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

HAPROXY_CFG_PATH="/opt/huawei/dj/etc/haproxy"
TOOL_PATH="/opt/huawei/dj/tools/services/haproxy"
VERSION_PATH="/opt/huawei/dj/versions/"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
HA_PLUGIN_PATH="/usr/local/bin/ha/ha/module/harm/plugin"

function deploy_uninstall_script()
{
    services_inst_dir="/opt/huawei/dj/inst/services/haproxy"
    mkdir -p ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/haproxy.yaml ${services_inst_dir}
    /usr/bin/cp -f ${CURRENT_PATH}/uninstall.sh ${services_inst_dir}
}


function install_rsyslog()
{
    local rsyslog_conf_dir="/etc/rsyslog.d/"
    log_info "Copy rsyslog_haproxy.conf to ${rsyslog_conf_dir}..."
    /usr/bin/cp ${CURRENT_PATH}/rsyslog_haproxy.conf ${rsyslog_conf_dir}
    CHECK_RESULT $? "Copy rsyslog_haproxy.conf ${rsyslog_conf_dir} failed."

    log_info "Restart rsyslog..."
    service rsyslog restart
    if [ $? -ne 0 ];then
       log_info "Restart rsyslog failed, wait 10 seconds to retry..."
       sleep 10
       service rsyslog restart
       log_info "Result code of restarting rsyslog is:$?"
    fi
}

function install_haproxy()
{
    csbs_python -m pip install --no-deps --force-reinstall  ${LINE_ROOT}/repo/self_developed/haproxyreg*.whl
    CHECK_RESULT $? "pip install haproxyreg failed."
    log_info "Install haproxy register finished."
    setprivilege /usr/lib/csbs_python/site-packages
    setprivilege /opt/huawei/dj/etc/haproxy

    mkdir -p ${VERSION_PATH}
    /usr/bin/cp -f  ${CURRENT_PATH}/haproxy.ver ${VERSION_PATH}
    setprivilege ${VERSION_PATH}
    CHECK_RESULT $? "Copy haproxy.ver to ${VERSION_PATH} failed."

    mkdir -p ${INSPECT_SH_PATH} ${HAPROXY_CFG_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/inspect/haproxy.sh ${INSPECT_SH_PATH}
    setprivilege ${INSPECT_SH_PATH}
    CHECK_RESULT $? "Copy  ${CURRENT_PATH}/inspect/haproxy.sh to ${INSPECT_SH_PATH} failed."

    mkdir -p ${HA_PLUGIN_PATH}/{conf,script}
    chmod 550 ${CURRENT_PATH}/script/*.sh
    /usr/bin/cp -f ${CURRENT_PATH}/script/*.xml ${HA_PLUGIN_PATH}/conf
    /usr/bin/cp -f ${CURRENT_PATH}/script/*.sh ${HA_PLUGIN_PATH}/script
    setprivilege ${HA_PLUGIN_PATH}

    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f ${CURRENT_PATH}/cli_tools/* ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    setprivilege ${TOOL_PATH}
    create_link ${TOOL_PATH}/haproxyinternalControl.sh
    log_info "Copy scripts in  ${CURRENT_PATH}/cli_client to ${TOOL_PATH} finished."
}

function set_sudoers_for_haproxy()
{
    sed -i "/\/haproxyinternalControl.sh/d" /etc/sudoers.d/openstack > /dev/null
    echo "%openstack ALL = (root) NOPASSWD:/opt/huawei/dj/tools/services/haproxy/haproxyinternalControl.sh" >> /etc/sudoers.d/openstack
}

function main()
{
    log_info "Begin to install haproxy..."
    deploy_uninstall_script
    install_haproxy
    install_rsyslog
    set_sudoers_for_haproxy
    log_info "Install haproxy finished."
}

main
