#!/bin/bash
#########################################
# Copyright (c) 2012-2015 Huawei .
# All rights reserved.
#
# Please send feedback to http://www.huawei.com
#
# Function
# revise note
########################################
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi

G_RESOURCE_NAME="hafloatIp"
G_ARPING="$(which arping)"
source /opt/huawei/dj/inst/bin/utils.sh
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}
LOG_FILE="/var/log/huawei/dj/services/system/ha/script.log"
HAPROXY_LABEL="haproxy"
HAPROXY_FLOAT_IP=$(get_info.py haproxy_float_ip)
NET_MASK=$(get_info.py manage_ip_netmask)
MANAGE_IP=$(get_info.py manage_ip)
INTERFACE_OF_MANAGE=""
INTERFACE_OF_HAPROXY=""


function get_floatip_information()
{
    NET_LIST=`ls /sys/class/net`
    for NET in ${NET_LIST};do
        RET=`/sbin/ip addr show ${NET}|grep "${MANAGE_IP}"| wc -l`
        if [ ${RET} -ne 0 ];then
            INTERFACE_OF_MANAGE=${NET}
        fi
        RET=`/sbin/ip addr show ${NET}|grep "${HAPROXY_FLOAT_IP}"| wc -l`
        if [ ${RET} -ne 0 ];then
            INTERFACE_OF_HAPROXY=${NET}
        fi
    done
}

#******************************************************************#
# Function: set_floatip
# Description: The function to set floatIP 
# Input Parameters:
# None
# Return : 0 success
#      1 failed
#******************************************************************#
function set_floatip()
{
    ip addr | grep "\ ${HAPROXY_FLOAT_IP}/" | grep -v grep >> /dev/null 2>&1
    if [ $? -eq 0 ];then
        log_warn "${HAPROXY_FLOAT_IP} has been set."
        return 0
    fi
    karbor_ping -c 3 ${HAPROXY_FLOAT_IP} >/dev/null
    if [ $? -eq 0 ];then
        log_warn "${HAPROXY_FLOAT_IP} has been used somewhere,please check whether if the ip is available "
        return 0
    fi
    ip addr add ${HAPROXY_FLOAT_IP}/${NET_MASK} dev ${INTERFACE_OF_MANAGE} label ${INTERFACE_OF_MANAGE}:${HAPROXY_LABEL} > /dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "Set ${HAPROXY_FLOAT_IP} failed."
        return 1
    fi
    ${G_ARPING} -c 1 -A -I ${INTERFACE_OF_MANAGE} ${HAPROXY_FLOAT_IP} 2>/dev/null
    log_info "${HAPROXY_FLOAT_IP} has been set."
    return 0
}

#******************************************************************#
# Function: unset_floatip
# Description: The function to unset floatIP 
# Input Parameters:
# None
# Return : 0 success
#      1 failed
#******************************************************************#
function unset_floatip()
{
    ip addr | grep "\ ${HAPROXY_FLOAT_IP}/" | grep -v grep >> /dev/null 2>&1
    if [ $? -ne 0 ];then
        log_warn "${HAPROXY_FLOAT_IP} is not exist."
        return 0
    fi
    ip addr del ${HAPROXY_FLOAT_IP}/${NET_MASK} dev ${INTERFACE_OF_HAPROXY} > /dev/null 2>&1
    log_info "${HAPROXY_FLOAT_IP} has been unset."
    return 0
    
}

#******************************************************************#
# Function: status
# Description: The function to query the status of floatIP 
# Input Parameters:
# None
# Return : 0 running
#      2 stopped
#******************************************************************#
function status()
{
    local L_RET=""
    ip add | grep "\ ${HAPROXY_FLOAT_IP}/" | grep -v grep >> /dev/null 2>&1
    if [ $? -ne 0 ];then
        log_info "${HAPROXY_FLOAT_IP} is stopped."
        return 2
    fi
    log_info "${HAPROXY_FLOAT_IP} is running."
    return 0
}


#******************************************************************#
# Function: main
# Description: main
# Input Parameters:action
# Return : 0 double mode 
#exit code:
# single / active-active
#   0 = normal
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   4 = starting
#   5 = stopping
#   10 = invaild action
#
# active-standby
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   6 = active normal
#   7 = standby normal
#   8 = switching to active
#   9 = switching to standby
#   10 = invaild action
#******************************************************************#
function main ()
{
    if [ ! -f "/opt/huawei/dj/versions/haproxy.ver" ];then
        exit 0
    fi
    case $1 in
    status)
        get_floatip_information
        if [ $? -ne 0 ];then 
            exit 2
        fi
        status
        exit $?
        ;;
    start)
        get_floatip_information
        if [ $? -ne 0 ];then
            exit 1
        fi
        set_floatip
        exit $?
        ;;
    stop)
        get_floatip_information
        unset_floatip
        exit 0
        ;;
    force-stop)
        get_floatip_information
        unset_floatip
        exit 0
        ;;
    *)
        log_warn "Operation($1) not support."
        exit 10
        ;;
    esac
}
main $@
