#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

function wait_start()
{
    local count=300
    while [ ${count} -gt 0 ];do
        csbs_python -c "from basesdk import utils;exit(utils.test_gaussdb_connect())"
        if [ $? -eq 0 ];then
            return 0
        fi
        let count--
        sleep 5s
    done
    return 1
}

function main()
{
    if [ -f /usr/bin/omm-haControl ];then
        omm-haControl -A RESTART
    fi
    wait_start
    if [ -f /usr/bin/haproxyinternalControl ];then
        haproxyinternalControl -A RESTART
    fi
    log_info "Start haproxy finished."
}

main