#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"

HAPROXY_PATH="/opt/huawei/dj/etc/haproxy"
HAPROXY_LOG_PATH="/var/log/huawei/dj/services/system/haproxy"
CLI_CLIENT_DIR="/opt/huawei/dj/tools/services/haproxy"
VERSION_PATH="/opt/huawei/dj/versions"
INSPECT_SH_PATH="/opt/huawei/dj/inspect/sh"
SERV_IMG_VERSION=`read_microservice_ver ${VERSION_PATH}/haproxy.ver`

function stop_service()
{
    log_info "Begin to stop haproxy ..."
    if [ -f "/usr/bin/haproxyinternalControl" ];then
        haproxyinternalControl -S STOP
        if [ $? -ne 0 ];then
            log_warn "Stop haproxy failed."
        fi
    fi
    log_info "Stop haproxy finished."
}

function uninstall_rpm()
{
    rpm_num=`rpm -qa|grep haproxyreg|grep -v grep|wc -l`
    if [ ${rpm_num} -gt 0 ];then
        rpm -e haproxyreg --nodeps
    fi
}

function remove_container()
{
    local container_name=$1
    log_info "Begin to delete container instance ${container_name}..."
    docker rm -f ${container_name} >/dev/null 2>&1
    if [ $? -eq 0 ];then
        log_info "Delete container instance ${container_name} finished."
        return 0
    else
        log_error "delete container ${container_name} failed."
    fi
}

function remove_image()
{
    local image_name=$1
    log_info "Begin to delete docker image ${image_name}..."
    for cur_idx in $(seq 1 6)
    do
        local img_num=`docker images -q ${image_name}|wc -l`
        if [ $? -ne 0 -o ${img_num} -gt 0 ];then
            docker rmi -f ${image_name} >/dev/null 2>&1
            sleep 1
        else
            log_info "Delete docker image ${image_name} finished."
            return 0
        fi
    done

    log_error "delete image ${image_name} failed."
    exit 1
}

function uninstall_img()
{
    remove_container "haproxyinternal"
    image_name="haproxy:${SERV_IMG_VERSION}"
    remove_image ${image_name}
}

function uninstall_files()
{
    log_info "Remove links of haproxy..."
    rm -f /usr/bin/haproxyinternalControl
    rm -f ${INSPECT_SH_PATH}/haproxy.sh

    #remove dirs
    all_dir=(
        ${HAPROXY_PATH}
        ${HAPROXY_LOG_PATH}
        ${CLI_CLIENT_DIR}
    )

    for cur_dir in ${all_dir[@]}
    do
        log_info "Remove directory ${cur_dir}..."
        rm -rf ${cur_dir}
        if [ $? -ne 0 ];then
            log_error "Remove directory ${cur_dir} failed."
        fi
    done

    #rsyslog
    rm -f /etc/rsyslog.d/rsyslog_haproxy.conf
    log_info "Restart rsyslog..."
    service rsyslog restart
    rm -f ${VERSION_PATH}/haproxy.ver
    sed -i '/\/replace_haproxy_conf.sh/d' /etc/sudoers.d/djmanager >/dev/null 2>&1
}

function main()
{
    log_info "Begin to uninstall haproxy..."
    stop_service
    uninstall_img
    uninstall_rpm
    uninstall_files
    log_info "Uninstall haproxy successfully."
}

main
