#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/haproxy_upgrade.log"

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ $? -ne 0 ]; then
        log_error "backup haproxy failed."
        return 1
    fi
    log_info "backup haproxy success."
    backup_image ${CURRENT_DIR}/backup_files/ "haproxy"
    if [ $? -ne 0 ];then
        log_error "Error to save haproxy image."
        return 0
    fi
    log_info "backup haproxy image success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write haproxy
    if [ $? -ne 0 ];then
        log_error "failed to write haproxy upgrade flag."
        return 1
    fi
    log_info "success to write haproxy upgrade flag."
    return 0
}

function install_new_haproxy()
{
    bash ${CURRENT_DIR}/../uninstall.sh >/dev/null 2>&1
    bash ${CURRENT_DIR}/../merge.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "merge haproxy image failed."
        return 1
    fi
    log_info "merge haproxy image success."
    bash ${CURRENT_DIR}/../install.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "install haproxy  failed."
        return 1
    fi
    log_info "install haproxy  success."
    bash ${CURRENT_DIR}/../config.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "config haproxy  failed."
        return 1
    fi
    log_info "config haproxy  success."
    bash ${CURRENT_DIR}/../start.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        log_error "start haproxy  failed."
        return 1
    fi
    log_info "start haproxy  success."
    return 0
}

function get_password()
{
    local private_key='/opt/huawei/dj/DJSecurity/privkey/privkey.conf'
    local key=$(cat "${private_key}" | awk '{print $2}')
    export ENCRYPT_DATA="${key}"
    csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0))"
}

function encrypt_haproxy_cert()
{
    haproxy_cert="/opt/huawei/dj/DJSecurity/server-cert/haproxy/haproxy-cert.pem"
    if grep -q "ENCRYPTED" "${haproxy_cert}";then
        return 0
    fi
    cert_manager --cert "${haproxy_cert}"
    if [[ $? -ne 0 ]];then
        log_error "Failed to encrypt haproxy cert."
        return 1
    fi
    log_info "Succeed to encrypt haproxy cert."
}

function main()
{
    log_info "Begin to upgrade haproxy..."
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    encrypt_haproxy_cert; CHECK_RESULT $?
    install_new_haproxy; CHECK_RESULT $?
    log_info "Upgrade haproxy finished."
    return 0
}

main
log_info "upgrade haproxy success."
exit 0