#!/bin/bash
source /opt/huawei/dj/inspect/inspectLib.sh
SSH_KEY_OUT_FILE="/opt/huawei/dj/DJSecurity/ssh/inspect"
SSH_OPT="-o StrictHostKeyChecking=no -o ConnectTimeout=2 -i ${SSH_KEY_OUT_FILE}"
source /opt/huawei/dj/inst/bin/utils.sh

# --------------------------  functions  ----------------------- ------------- #
# **************************************************************************** #
# Function Name: CheckAndExecCommand
# Description: Entrance of this scripts
# Parameter:
# Return:
# **************************************************************************** #
CheckAndExecCommand ()
{
    #除了CheckClusterStatus，其余的函退出的值要么为0(成功)，要么为1(失败)
    #CHECK_CMD -- node ip
    CHECK_CMD=$1
    case $3 in
    clusterStatus)
        CheckClusterStatus ${CHECK_CMD};;
    memory)
         CheckMemInfo ${CHECK_CMD};;
    diskfree)
        CheckDiskFree ${CHECK_CMD};;
    cpuStatus)
        CheckCpuStatus ${CHECK_CMD};;
    cps-monitor)
        CheckCpsMonitor ${CHECK_CMD};;
    cms)
        CheckCms ${CHECK_CMD};;
    zookeeper)
        CheckZookeeper ${CHECK_CMD};;
    gaussdb)
        CheckGaussdb ${CHECK_CMD};;
    omm-ha)
        CheckOmmha ${CHECK_CMD};;
    haproxy)
        CheckHaproxy ${CHECK_CMD};;
    rabbitmq)
        CheckRabbitmq ${CHECK_CMD};;
    scagent)
        CheckScagent ${CHECK_CMD};;
    resource_manager)
        CheckResourceManager ${CHECK_CMD};;
    karbor)
        CheckKarbor ${CHECK_CMD};;
    defaultPwd)
        CheckDefaultPwd ${CHECK_CMD};;
    esac
}

CheckClusterStatus ()
{
    mynode=$(csbs_python /usr/bin/get_info.py --manage_ip)
    nodelist=($(csbs_python /usr/bin/get_info.py --manage_ip list |sed 's/,/\ /g'))
    gen_ssh_key
    msg=''
    ret=0
    if [ ${#nodelist[@]} -ge 1 ] ;then
        for node in ${nodelist[@]};do
            if [ "X$mynode" == "X$node" ];then
                msg=$msg'||'$node:'up'
                continue
            fi
            check_logon $node djmanager "${SSH_OPT}">>/dev/null
            if [ $? -ne 0 ];then
                msg=$msg'||'$node:'down'
                ret=1
            else
                msg=$msg'||'$node:'up'
            fi
        done
    fi
    echo $msg
    rm -f ${SSH_KEY_OUT_FILE}
    exit $ret
}

CheckMemInfo ()
{
    if [  -e /etc/euleros-release ];then
        freeSpaceMB=`free -m |awk '/Mem/ {print $2-$3}'`
    else
        freeSpaceMB=`free -m|sed -n '3p'|awk '{print $4}'`
    fi

    msg="$1 Free Memory":$freeSpaceMB'MB'
    ret=0
    if [ $freeSpaceMB -lt 1024 ]
    then
        ret=1
    fi
    echo $msg
    exit $ret
}

echoPathFree()
{
    if [ ! -d $1 ];then
        echo "$1 path: Not Exist"
        return 1
    fi
    freeSpaceMB=`df -m $1|sed -n '2p'|awk '{print $4}'`
    ret=0
    [ $freeSpaceMB -lt 1024 ] && ret=1
    msg="$2 $1 Disk Free":$freeSpaceMB'MB'
    echo $msg
    return $ret
}

CheckDiskFree ()
{
    #/var/log disk free
    echoPathFree "/var/log" $1
    exit $?
}

CheckCpuStatus ()
{
    #cpu可用资源比例
    local cpuTotal=`top -b -n 1 2>/dev/null|grep 'load average'|awk -F',' '{print $NF}'`
    local coreNum=`cat /proc/cpuinfo| grep processor| wc -l`
    local cpu=$(python -c "print(int((1-${cpuTotal}/${coreNum})*100))")
    local ret=0
    if [[ ${cpu} -le 20 ]]
    then
        ret=1
    fi
    echo "$1 Cpu Idle:"${cpu}'%'
    exit ${ret}
}

CheckCpsMonitor ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/cps-monitor.sh" ];then
        echo "$1 cps-monitor: N/A"
        exit 10 #不涉及
    fi

    check 'cps_monitor_process'                   "$1 cps-monitor" "cps-monitor" \
          'sys_monitor_process'                   "$1 sys-monitor" "cps-monitor"
    exit $?
}

CheckZookeeper ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/zookeeper.sh" ];then
        echo "$1 zookeeper: N/A"
        exit 10 #不涉及
    fi

    check 'zookeeper_process'                   "$1 zookeeper" "zookeeper"
    exit $?
}

CheckGaussdb ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/gaussdb.sh" ];then
        echo "$1 gaussdb: N/A"
        exit 10 #不涉及
    fi

    check 'gaussdb_process'                         "$1 gaussdb" "gaussdb"
    exit $?
}

CheckOmmha ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/omm-ha.sh" ];then
        echo "$1 omm-ha: N/A"
        exit 10 #不涉及
    fi

    check 'omm_ha_process'                         "$1 omm-ha" "omm-ha"
    exit $?
}


CheckHaproxy ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/haproxy.sh" ];then
        echo "$1 haproxy: N/A"
        exit 10 #不涉及
    fi

    check 'haproxyinternal'                 "$1 haproxyinternal" "haproxy"
    exit $?
}

CheckRabbitmq ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/rabbitmq.sh" ];then
        echo "$1 rabbitmq: N/A"
        exit 10 #不涉及
    fi

    check 'rabbitmq_process'                   "$1 rabbitmq" "rabbitmq"
    exit $?
}

CheckCms ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/cms.sh" ];then
        echo "$1 cms: N/A"
        exit 10 #不涉及
    fi

    check 'cms_process'                         "$1 cms" "cms"
    exit $?
}

CheckResourceManager ()
{
   local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/resource_manager.sh" ];then
        echo "$1 resource_manager: N/A"
        exit 10 #不涉及
    fi

    check 'resource_manager'      "$1 resource_manager" "resource_manager"
    exit $?
}

CheckScagent ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/scagent.sh" ];then
        echo "$1 scagent: N/A"
        exit 10 #不涉及
    fi

    check 'scagent_process'                         "$1 scagent" "scagent"
    exit $?
}

CheckKarbor ()
{
    local INSPECT_SH="/opt/huawei/dj/inspect/sh"
    if [ ! -f "${INSPECT_SH}/karbor.sh" ];then
        echo "$1 karbor: N/A"
        exit 10 #不涉及
    fi

    check 'karbor_api_process'                   "$1 karbor-api" "karbor" \
          'karbor_protection_process'            "$1 karbor-protection" "karbor" \
          'karbor_operationengine_process'       "$1 karbor-operationengine" "karbor" \
          'service_status'                       "$1 service_status" "karbor"\
          'karbor_docking_status'                "$1 karbor_docking_status" "karbor"\
          'docker_status'                        "$1 docker_status" "karbor"
    exit $?
}

CheckDefaultPwd ()
{
    default_pwd=`cat /opt/huawei/dj/cfg/sys.ini | grep 'default_user_pwd' | awk -F ' ' '{print $3}'`
    default_pwd_decrypt=`csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0, '${default_pwd}'))"`
    haproxy_pwd=`csbs_python -c "from basesdk import cms_info;print(cms_info.get_cms_info(\"haproxy.db_user_pass\"))" | awk -F '\"' '{print $8}'`
    haproxy_pwd_decrypt=`csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0, '${haproxy_pwd}'))"`
    karbor_pwd=`csbs_python -c "from basesdk import cms_info;print(cms_info.get_cms_info(\"karbor.db_user_pass\"))" | awk -F '\"' '{print $8}'`
    karbor_pwd_decrypt=`csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0, '${karbor_pwd}'))"`
    rabbitmq_pwd=`csbs_python -c "from basesdk import cms_info;print(cms_info.get_cms_info(\"rabbitmq.pwd\"))"`
    rabbitmq_pwd_decrypt=`csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0, '${rabbitmq_pwd}'))"`
    cms_pwd=`cat /opt/huawei/dj/etc/cms/cms.conf | grep 'connection' | awk -F ':' '{print $3}' | awk -F '@' '{print $1}'`
    cms_pwd_decrypt=`csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0, '${cms_pwd}'))"`
    zookeeper_pwd=`cat /opt/fusionplatform/data/openstack/zkClient.conf | grep 'data_kmc' | head -n 1 | awk -F '=' '{print $2}'`
    zookeeper_pwd_decrypt=`csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0, '${zookeeper_pwd}'))"`
    gaussdb_admin_pwd=`cat /opt/huawei/dj/cfg/sys.ini | grep 'gaussdb_admin_pwd' | awk -F ' ' '{print $3}'`
    gaussdb_pwd_decrypt=`csbs_python -c "from kmc import kmc;print(kmc.API().decrypt(0, '${gaussdb_admin_pwd}'))"`
    local ret=0
    if [[ "${default_pwd_decrypt}" == "${haproxy_pwd_decrypt}" ]]; then
      echo "The password of haproxy uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${karbor_pwd_decrypt}" ]]; then
      echo "The password of karbor uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${rabbitmq_pwd_decrypt}" ]]; then
      echo "The password of rabbitmq uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${cms_pwd_decrypt}" ]]; then
      echo "The password of cms uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${zookeeper_pwd_decrypt}" ]]; then
      echo "The password of zookeeper uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${gaussdb_pwd_decrypt}" ]]; then
      echo "The password of gaussdb_admin uses the default one."
      ret=1
    fi

    exit ${ret}
}

################################  main  #########################################
INPUT_PARA_NUM=$#
if [[ ${INPUT_PARA_NUM} -lt 3 ]]
then
    echo "Usage: inspect.sh <ip> -c <param>"
fi
CheckAndExecCommand $*
exit 3 #不涉及
