#!/bin/bash
PATH=/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/usr/X11R6/bin:/usr/games:/usr/lib/mit/bin:/usr/lib/mit/sbin:$PATH
MY_NODE=$(csbs_python /usr/bin/get_info.py manage_ip)
NODE_LIST=($(csbs_python /usr/bin/get_info.py manage_ip list |sed 's/,/\ /g'))
INSPECT_TOOL="/opt/huawei/dj/inspect/inspect.sh"
SSH_KEY_OUT_FILE="/opt/huawei/dj/DJSecurity/ssh/inspectMain"
SSH_OPT="-o StrictHostKeyChecking=no -o ConnectTimeout=2 -i ${SSH_KEY_OUT_FILE}"
CHECK_RESULT_FILE="/tmp/toolkit_check_inspect_out.xml"
source /opt/huawei/dj/inspect/inspectLib.sh
source /opt/huawei/dj/inst/bin/utils.sh
gen_ssh_key


profile=`csbs_python /usr/bin/get_info.py profile`
if [ "$profile" == "private_recover" ] || [ "$profile" == "private_kvm" ];then
    numth=3
else
    numth=0
fi

#when cluster,check can logon node list.
NEW_LIST=""
if [ ${#NODE_LIST[@]} -gt 1 ] ;then
     i=0
     for node in ${NODE_LIST[@]};do
        if [ $i -eq $numth ];then
           continue
        fi

        if [ "X$MY_NODE" == "X$node" ];then
            NEW_LIST="${NEW_LIST}$node "
            let i++
            continue
        fi
        check_logon $node djmanager "$SSH_OPT" >> /dev/null
        if [ $? -eq 0 ];then
            NEW_LIST="${NEW_LIST}$node "
        fi
        let i++
     done
     NODE_LIST=($NEW_LIST)
fi

################################ main #####################################
case $2 in
clusterStatus)
    msg=`/usr/bin/bash ${INSPECT_TOOL} ${MY_NODE} $@`;;
omm-ha)
    msg=`exec_cmd_only_2_node_succ $@`;;
gaussdb)
    msg=`exec_cmd_only_2_node_succ $@`;;
defaultPwd)
    msg=`/usr/bin/bash ${INSPECT_TOOL} ${MY_NODE} $@`;;
*)
    msg=`exec_cmd_all_node $@`;;
esac

ret=$?

InitFile $CHECK_RESULT_FILE
WriteResultHeaderToXml $2
if [ $ret -eq 0 ];then
    WriteNormalItemResultToXml "$20" 0 "$msg"
else
    WriteErrorItemResultToXml "$20" 0 "$msg" $ret
fi
WriteResultEndToXml
cat $CHECK_RESULT_FILE
rm -f $CHECK_RESULT_FILE
rm -f ${SSH_KEY_OUT_FILE}
exit $ret