#!/bin/bash
CURRENT_DIR=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname $(dirname ${CURRENT_DIR})))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/services/system/upgradeagent/inspect_upgrade.log"

sh ${CURRENT_DIR}/precheck.sh
if [ $? -ne 0 ];then
    log_error "failed to precheck inspect"
    exit 1
fi

function backup_files()
{
    backup_or_rollback back ${CURRENT_DIR}/backup_files/package.tar.gz ${CURRENT_DIR}/upgrade_files.conf
    if [ "$?" -ne "0" ];then
        log_error "backup inspect failed."
        return 1
    fi
    log_info "backup inspect success."
    return 0
}

function set_upgrade_flag()
{
    should_rollback write inspect
    if [ $? -ne 0 ];then
        log_error "failed to write inspect upgrade flag."
        return 1
    fi
    log_info "success to write inspect upgrade flag."
    return 0
}

function install_new_inspect()
{
    sh ${CURRENT_DIR}/../install.sh
    if [ "$?" -ne "0" ];then
        log_error "install new inspect failed."
        return 1
    fi
    log_info "install new inspect success."
}

function main()
{
    backup_files; CHECK_RESULT $?
    set_upgrade_flag; CHECK_RESULT $?
    install_new_inspect; CHECK_RESULT $?
}

main
log_info "upgrade inspect success."
exit 0