#!/usr/bin/env bash
if [[ ${UID} -ne 0 ]];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
CUR_DIR=$(cd $(dirname ${BASH_SOURCE[0]}) && pwd)
source /opt/huawei/dj/inst/bin/utils.sh
SYS_INI="/opt/huawei/dj/cfg/sys.ini"
CMS_CONFIG_FILE_PATH="/opt/huawei/dj/etc/cms/cms.conf"

function sync_cert()
{
    cloud_db_source_ca="/tmp/cloud_db_cacert.pem"
    cloud_db_dest_dir="/opt/huawei/dj/DJSecurity/server-ca/"

    mv ${cloud_db_source_ca} ${cloud_db_dest_dir}/cloud_db_cacert.pem
    chmod 640 ${cloud_db_dest_dir}/cloud_db_cacert.pem
    chown -h root:openstack ${cloud_db_dest_dir}/cloud_db_cacert.pem
    write_ini_file SYSTEM db_ca_file "\/opt\/huawei\/dj\/DJSecurity\/server-ca\/cloud_db_cacert.pem" ${SYS_INI}
}

function rollback_cert()
{
    write_ini_file SYSTEM db_ca_file "\/opt\/huawei\/dj\/DJSecurity\/server-ca\/ca-cert.pem" ${SYS_INI}
}

function modify_gaussdb_float_ip()
{
    write_ini_file SYSTEM gaussdb_float_ip $1 ${SYS_INI}
}

function restart_service()
{
    karbor-apiControl -F RESTART >> /dev/null 2>&1
    karbor-protectionControl -F RESTART >> /dev/null 2>&1
    karbor-operationControl -F RESTART >> /dev/null 2>&1
    cmsControl -A RESTART >> /dev/null 2>&1
}

function config_cms_conf()
{
    /usr/bin/cp -f "/CAD/CSBS/services/cms/cms.conf" ${CMS_CONFIG_FILE_PATH}
    source /CAD/CSBS/bin/utils.sh
    db_float_ip=`get_info.py gaussdb_float_ip`
    db_cms_password=`get_info.py gaussdb_admin_pwd`
    db_ca_file=`get_info.py db_ca_file`
    replace_variable db_cms_password ${CMS_CONFIG_FILE_PATH}
    replace_variable db_float_ip ${CMS_CONFIG_FILE_PATH}
    replace_variable db_ca_file ${CMS_CONFIG_FILE_PATH}
}

action=`echo $1|awk -F "_" '{print $1}'`
float_ip=`echo $1|awk -F "_" '{print $2}'`
if [[ ${action} == 'migrate' ]]; then
    sync_cert
elif [[ ${action} == 'rollback' ]]; then
    rollback_cert
fi
modify_gaussdb_float_ip ${float_ip}
config_cms_conf
restart_service
