#!/bin/bash
if [[ ${UID} -ne 0 ]];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
CUR_DIR=$(cd $(dirname ${BASH_SOURCE[0]}) && pwd)
source /opt/huawei/dj/inst/bin/utils.sh
SYS_INI="/opt/huawei/dj/cfg/sys.ini"

function add_info_for_sys_ini()
{
    rabbitmq_nodes=`cat ${SYS_INI}|grep rabbitmq_nodes|cut -d = -f 2`

    ret=`zgrep "${1}" ${SYS_INI}`
    if [[ ${ret} == "" ]];then
        write_ini_file SYSTEM rabbitmq_nodes "${rabbitmq_nodes},${1}" ${SYS_INI}
        echo "[${1}]" >> ${SYS_INI}
        cur_node_str=`echo ${1}|sed "s/\.*//g"`
        echo "hostname = karbor${cur_node_str}" >> ${SYS_INI}
        echo "tenant_ip = ${1}" >> ${SYS_INI}
        echo "internal_ip = ${1}" >> ${SYS_INI}
    fi
}

function delete_info_form_sys_ini()
{
    cur_node=`/sbin/ifconfig eth0|grep inet|grep -v 127.0.0.1|grep -v inet6 | awk '{print $2}' | tr -d "addr:"`
    if [[ "${cur_node}" == "${1}" ]];then
        exit 0
    fi
    rabbitmq_nodes=`cat ${SYS_INI}|grep rabbitmq_nodes|cut -d = -f 2`
    arr=(${rabbitmq_nodes//,/ })
    new_rabbitmq_nodes=""
    for node in ${arr[@]}
    do
        if [[ "${node}" != "${1}" ]];then
            if [[ "${new_rabbitmq_nodes}" == "" ]];then
                new_rabbitmq_nodes=$node
            else
                new_rabbitmq_nodes="$new_rabbitmq_nodes,$node"
            fi
        fi
    done
    if [[ "${new_rabbitmq_nodes}" == "" ]];then
        exit 1
    fi
    sed -i '/^rabbitmq_nodes =/c'rabbitmq_nodes\ =\ ${new_rabbitmq_nodes}'' ${SYS_INI}
    sed -i "/\[${1}\]/,/internal_ip\ =\ ${1}/d" ${SYS_INI}
}

function restart_service()
{
    rabbitmqControl -A RESTART >> /dev/null 2>&1
    karbor-apiControl -F RESTART >> /dev/null 2>&1
    karbor-protectionControl -F RESTART >> /dev/null 2>&1
    karbor-operationControl -F RESTART >> /dev/null 2>&1
}

action=`echo $1|awk -F "_" '{print $1}'`
ip=`echo $1|awk -F "_" '{print $2}'`
if [[ ${action} == 'add' ]]; then
    add_info_for_sys_ini ${ip}
elif [[ ${action} == 'del' ]]; then
    delete_info_form_sys_ini ${ip}
fi
restart_service