#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) $@;exit $?
fi
source /opt/huawei/dj/inst/bin/utils.sh
PROFILE=$(get_info.py --profile)

if [[ "$1" == "openstack" ]] || [[ "$1" == "CSBS_VBS-fsp" ]];then
    DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/server-cert/karbor/openstack/nova_ca.crt
elif [[ "$1" == "iam" ]] && [[ "${PROFILE}" == "public" ]];then
    DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/server-ca/trust.cer
elif [[ "$1" == "iam" ]] || [[ "$1" == "CSBS_VBS-MO-IAM" ]];then
    DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/mo_certs/trust_iam.cer
elif [[ "$1" == "CSBS_VBS-MO-OC" ]];then
    DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/mo_certs/trust_oc.cer
elif [[ "$1" == "CSBS_VBS-MO-SC" ]];then
    DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/mo_certs/trust_sc.cer
elif [[ "$1" == "iam_global" ]];then
    DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/server-ca/global_trust.cer
elif [[ "$1" == "CSBS_VBS-internal" ]];then
    DEST_CERT_FILE=/opt/huawei/dj/DJSecurity/mo_certs/replace_server
else
    exit 1
fi
read -s -t 60 cert_data
mkdir -p $(dirname ${DEST_CERT_FILE})
echo ${cert_data} | base64 -d > ${DEST_CERT_FILE}
setprivilege $(dirname ${DEST_CERT_FILE})
exit 0
