#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_FILE="/var/log/huawei/dj/install.log"
SERV_IMG_VERSION=`read_microservice_ver ${CURRENT_PATH}/karbor.ver`
cluster_first_node=$(get_info.py cluster_first_node)

function wait_start()
{
    local count=300
    while [[ ${count} -gt 0 ]];do
        curl -i -k https://${cluster_first_node}:28799 >/dev/null 2>&1
        if [[ $? -eq 0 ]];then
            return 0
        fi
        let count--
        sleep 5s
    done
    return 1
}

function init_db()
{
    mkdir -p /var/log/huawei/dj/services/system/karbor
    chmod 770  /var/log/huawei/dj/services/system/karbor
    chown -h root:openstack /var/log/huawei/dj/services/system/karbor
    docker rm -f init_db >/dev/null 2>&1
    docker run -d --cpu-shares 1024 --security-opt=no-new-privileges --ipc=host --memory 4000m --net=host \
    -v /usr/bin/get_info.py:/usr/bin/get_info.py:ro \
    -v /opt/huawei/dj/cfg:/opt/huawei/dj/cfg:ro \
    -v /opt/huawei/dj/paas:/opt/huawei/dj/paas:ro \
    -v /opt/huawei/dj/DJSecurity:/opt/huawei/dj/DJSecurity \
    -v /etc/localtime:/etc/localtime:ro \
    -v /var/log/huawei/dj/services/system/karbor:/var/log/install/ \
    -v /opt/fusionplatform/data/openstack/:/opt/fusionplatform/data/openstack/ \
    -v /var/log/huawei/dj/services/system/karbor:/var/log/karbor \
    --name init_db karbor:${SERV_IMG_VERSION} sleep 9999999
    CHECK_RESULT "$?" "Docker run when init_db failed"
    docker exec -u root init_db bash /installfiles/comp/karbor/init_db.sh
    CHECK_RESULT "$?" "Docker exec when init_db failed"
    docker rm -f init_db >/dev/null 2>&1
}

log_info "Start config."
if [[ $(get_info.py node_index) -ne 1 ]];then
    wait_start;CHECK_RESULT "$?" "Wait karbor start on first node failed"
else
    log_info "Begin to wait first node..."
    init_db;CHECK_RESULT "$?" "Init Karbor db failed"
    log_info "Wait first node finished."
fi
log_info "End config."
